---
UID: NS:mi._MI_Module
title: MI_Module (mi.h)
description: Generated by the provider, this object contains all the data needed by the provider manager to manage the providers within this module.
old-location: wmi_v2\mi_module.htm
tech.root: wmi_v2
ms.assetid: 76a034eb-f5e0-4da2-9c9d-99e196c17da5
ms.date: 12/05/2018
ms.keywords: MI_MODULE_FLAG_BOOLEANS, MI_MODULE_FLAG_DESCRIPTIONS, MI_MODULE_FLAG_FILTER_SUPPORT, MI_MODULE_FLAG_LOCALIZED, MI_MODULE_FLAG_MAPPING_STRINGS, MI_MODULE_FLAG_STANDARD_QUALIFIERS, MI_MODULE_FLAG_VALUES, MI_Module, MI_Module structure [Windows Management Infrastructure (MI)], mi/MI_Module, wmi._mi_module, wmi_v2.mi_module
f1_keywords:
- mi/MI_Module
dev_langs:
- c++
req.header: mi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Mi.h
api_name:
- MI_Module
targetos: Windows
req.typenames: MI_Module
req.redist: Windows Management Framework 3.0 on Windows Server 2008 R2 with SP1, Windows 7 with SP1, and Windows Server 2008 with SP2
ms.custom: 19H1
---

# MI_Module structure


## -description


Generated by the provider, this object contains
   all the data needed by the provider manager to manage the providers within this
   module.


## -struct-fields




### -field version

The version the provider was compiled with (<b>MI_VERSION</b>).


### -field generatorVersion

The hex value of <b>MI_VERSION</b> when the generator was compiled.


### -field flags

Module flags.



#### MI_MODULE_FLAG_STANDARD_QUALIFIERS ((1 << 0))

Whether standard qualifiers were generated.



#### MI_MODULE_FLAG_DESCRIPTIONS ((1 << 1))

Whether description qualifiers were generated.



#### MI_MODULE_FLAG_VALUES ((1 << 2))

Whether Values and ValueMap qualifiers were generated.



#### MI_MODULE_FLAG_MAPPING_STRINGS ((1 << 3))

Whether the MappingStrings qualifiers were generated.



#### MI_MODULE_FLAG_BOOLEANS ((1 << 4))

Whether the boolean qualifiers were generated.



#### MI_MODULE_FLAG_LOCALIZED ((1 << 6))

Whether translatable qualifiers were localized (and STRING.RC generated).



#### MI_MODULE_FLAG_FILTER_SUPPORT ((1<<7))

Whether filters are supported.


### -field charSize

Size of the MI_Char in bytes.


### -field schemaDecl

Pointer to generated schema declarations (static providers only).


### -field Load

Function pointer that points to the provider's Load function where initialization takes place.


### -field Unload

Function pointer that points to the provider's Unload function where cleanup takes place.


### -field dynamicProviderFT

The module may implement a single 'dynamic provider' (one that provides CIM instances, CIM classes and CIM 
      qualifier declarations). The provider manager uses this function table when it is non-null, and 
      <b>schemaDecl</b> is <b>NULL</b> or does not contain runtime type 
      information (RTTI)  corresponding to the given request.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/dn792322(v=vs.85)">MI_Module_Load</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/dn792323(v=vs.85)">MI_Module_Unload</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mi/ns-mi-mi_providerft">MI_ProviderFT</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mi/ns-mi-mi_schemadecl">MI_SchemaDecl</a>
 

 

