---
UID: NE:micaut.__MIDL___MIDL_itf_micaut_0000_0000_0001
title: MICUIELEMENT (micaut.h)
description: Specifies the user interface (UI) elements of a math input control (MIC).
old-location: tablet\micuielement.htm
tech.root: tablet
ms.assetid: 3091480b-cb75-4faf-9005-1d9ddccea236
ms.date: 12/05/2018
ms.keywords: MICUIELEMENT, MICUIELEMENT enumeration [Tablet PC], MICUIELEMENT_BUTTON_CANCEL, MICUIELEMENT_BUTTON_CLEAR, MICUIELEMENT_BUTTON_CORRECT, MICUIELEMENT_BUTTON_ERASE, MICUIELEMENT_BUTTON_INSERT, MICUIELEMENT_BUTTON_REDO, MICUIELEMENT_BUTTON_UNDO, MICUIELEMENT_BUTTON_WRITE, MICUIELEMENT_INKPANEL_BACKGROUND, MICUIELEMENT_RESULTPANEL_BACKGROUND, micaut/MICUIELEMENT, micaut/MICUIELEMENT_BUTTON_CANCEL, micaut/MICUIELEMENT_BUTTON_CLEAR, micaut/MICUIELEMENT_BUTTON_CORRECT, micaut/MICUIELEMENT_BUTTON_ERASE, micaut/MICUIELEMENT_BUTTON_INSERT, micaut/MICUIELEMENT_BUTTON_REDO, micaut/MICUIELEMENT_BUTTON_UNDO, micaut/MICUIELEMENT_BUTTON_WRITE, micaut/MICUIELEMENT_INKPANEL_BACKGROUND, micaut/MICUIELEMENT_RESULTPANEL_BACKGROUND, tablet.micuielement
f1_keywords:
- micaut/MICUIELEMENT
dev_langs:
- c++
req.header: micaut.h
req.include-header: Micaut.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Micaut.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- micaut.h
api_name:
- MICUIELEMENT
targetos: Windows
req.typenames: MICUIELEMENT
req.redist: 
ms.custom: 19H1
---

# MICUIELEMENT enumeration


## -description


 Specifies the user interface (UI) elements of a math input control (MIC).


## -enum-fields




### -field MICUIELEMENT_BUTTON_WRITE

The <b>Write</b> button.


### -field MICUIELEMENT_BUTTON_ERASE

The <b>Erase</b> button.


### -field MICUIELEMENT_BUTTON_CORRECT

The <b>Select and Correct</b> button.


### -field MICUIELEMENT_BUTTON_CLEAR

The <b>Clear</b> button.


### -field MICUIELEMENT_BUTTON_UNDO

The <b>Undo</b> button.


### -field MICUIELEMENT_BUTTON_REDO

The <b>Redo</b> button.


### -field MICUIELEMENT_BUTTON_INSERT

The <b>Insert</b> button.


### -field MICUIELEMENT_BUTTON_CANCEL

The <b>Cancel</b> button.


### -field MICUIELEMENT_INKPANEL_BACKGROUND

The writing-area background.


### -field MICUIELEMENT_RESULTPANEL_BACKGROUND

The result preview-area background.


## -remarks



This enumeration is used in custom painting.
  




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/math-input-control-reference">Math Input Control Reference</a>
 

 

