---
UID: NE:micaut.__MIDL___MIDL_itf_micaut_0000_0000_0002
title: MICUIELEMENTSTATE (micaut.h)
description: Specifies the button states of a math input control (MIC).
old-location: tablet\micuielementstate.htm
tech.root: tablet
ms.assetid: 6f2c9d45-ad2c-451a-8945-6c9f2f8d5f18
ms.date: 12/05/2018
ms.keywords: MICUIELEMENTSTATE, MICUIELEMENTSTATE enumeration [Tablet PC], MICUIELEMENTSTATE_DISABLED, MICUIELEMENTSTATE_HOT, MICUIELEMENTSTATE_NORMAL, MICUIELEMENTSTATE_PRESSED, micaut/MICUIELEMENTSTATE, micaut/MICUIELEMENTSTATE_DISABLED, micaut/MICUIELEMENTSTATE_HOT, micaut/MICUIELEMENTSTATE_NORMAL, micaut/MICUIELEMENTSTATE_PRESSED, tablet.micuielementstate
f1_keywords:
- micaut/MICUIELEMENTSTATE
dev_langs:
- c++
req.header: micaut.h
req.include-header: Micaut.h
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Micaut.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- micaut.h
api_name:
- MICUIELEMENTSTATE
targetos: Windows
req.typenames: MICUIELEMENTSTATE
req.redist: 
ms.custom: 19H1
---

# MICUIELEMENTSTATE enumeration


## -description


Specifies the button states of a math input control (MIC).


## -enum-fields




### -field MICUIELEMENTSTATE_NORMAL

The button does not have the mouse hovering over it.


### -field MICUIELEMENTSTATE_HOT

The button has the mouse hovering over it.


### -field MICUIELEMENTSTATE_PRESSED

The button is pressed.


### -field MICUIELEMENTSTATE_DISABLED

The button is disabled.


## -remarks



This enumeration is used in custom painting.  
  




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/tablet/math-input-control-reference">Math Input Control Reference</a>
 

 

