---
UID: NS:minidumpapiset._MINIDUMP_EXCEPTION
title: MINIDUMP_EXCEPTION (minidumpapiset.h)
description: Contains exception information.
old-location: base\minidump_exception_str.htm
tech.root: Debug
ms.assetid: edbb87a7-1b99-46bd-8797-c806861ec73a
ms.date: 12/05/2018
ms.keywords: '*PMINIDUMP_EXCEPTION, EXCEPTION_ACCESS_VIOLATION, EXCEPTION_ARRAY_BOUNDS_EXCEEDED, EXCEPTION_BREAKPOINT, EXCEPTION_DATATYPE_MISALIGNMENT, EXCEPTION_FLT_DENORMAL_OPERAND, EXCEPTION_FLT_DIVIDE_BY_ZERO, EXCEPTION_FLT_INEXACT_RESULT, EXCEPTION_FLT_INVALID_OPERATION, EXCEPTION_FLT_OVERFLOW, EXCEPTION_FLT_STACK_CHECK, EXCEPTION_FLT_UNDERFLOW, EXCEPTION_ILLEGAL_INSTRUCTION, EXCEPTION_INT_DIVIDE_BY_ZERO, EXCEPTION_INT_OVERFLOW, EXCEPTION_INVALID_DISPOSITION, EXCEPTION_IN_PAGE_ERROR, EXCEPTION_NONCONTINUABLE_EXCEPTION, EXCEPTION_PRIV_INSTRUCTION, EXCEPTION_SINGLE_STEP, EXCEPTION_STACK_OVERFLOW, MINIDUMP_EXCEPTION, MINIDUMP_EXCEPTION structure, PMINIDUMP_EXCEPTION, PMINIDUMP_EXCEPTION structure pointer, _MINIDUMP_EXCEPTION, _win32_minidump_exception_str, base.minidump_exception_str, minidumpapiset/MINIDUMP_EXCEPTION, minidumpapiset/PMINIDUMP_EXCEPTION'
f1_keywords:
- minidumpapiset/MINIDUMP_EXCEPTION
dev_langs:
- c++
req.header: minidumpapiset.h
req.include-header: DbgHelp.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- minidumpapiset.h
api_name:
- MINIDUMP_EXCEPTION
targetos: Windows
req.typenames: MINIDUMP_EXCEPTION, *PMINIDUMP_EXCEPTION
req.redist: DbgHelp.dll 5.1 or later
ms.custom: 19H1
---

# MINIDUMP_EXCEPTION structure


## -description


Contains exception information.


## -struct-fields




### -field ExceptionCode

The reason the exception occurred. This is the code generated by a hardware exception, or the code specified in the 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-raiseexception">RaiseException</a> function for a software-generated exception. Following are the exception codes likely to occur due to common programming errors. 



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_ACCESS_VIOLATION"></a><a id="exception_access_violation"></a><dl>
<dt><b>EXCEPTION_ACCESS_VIOLATION</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to read from or write to a virtual address for which it does not have the appropriate access.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_ARRAY_BOUNDS_EXCEEDED"></a><a id="exception_array_bounds_exceeded"></a><dl>
<dt><b>EXCEPTION_ARRAY_BOUNDS_EXCEEDED</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to access an array element that is out of bounds and the underlying hardware supports bounds checking.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_BREAKPOINT"></a><a id="exception_breakpoint"></a><dl>
<dt><b>EXCEPTION_BREAKPOINT</b></dt>
</dl>
</td>
<td width="60%">
A breakpoint was encountered.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_DATATYPE_MISALIGNMENT"></a><a id="exception_datatype_misalignment"></a><dl>
<dt><b>EXCEPTION_DATATYPE_MISALIGNMENT</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to read or write data that is misaligned on hardware that does not provide alignment. For example, 16-bit values must be aligned on 2-byte boundaries; 32-bit values on 4-byte boundaries, and so on.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_FLT_DENORMAL_OPERAND"></a><a id="exception_flt_denormal_operand"></a><dl>
<dt><b>EXCEPTION_FLT_DENORMAL_OPERAND</b></dt>
</dl>
</td>
<td width="60%">
One of the operands in a floating-point operation is denormal. A denormal value is one that is too small to represent as a standard floating-point value.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_FLT_DIVIDE_BY_ZERO"></a><a id="exception_flt_divide_by_zero"></a><dl>
<dt><b>EXCEPTION_FLT_DIVIDE_BY_ZERO</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to divide a floating-point value by a floating-point divisor of zero.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_FLT_INEXACT_RESULT"></a><a id="exception_flt_inexact_result"></a><dl>
<dt><b>EXCEPTION_FLT_INEXACT_RESULT</b></dt>
</dl>
</td>
<td width="60%">
The result of a floating-point operation cannot be represented exactly as a decimal fraction.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_FLT_INVALID_OPERATION"></a><a id="exception_flt_invalid_operation"></a><dl>
<dt><b>EXCEPTION_FLT_INVALID_OPERATION</b></dt>
</dl>
</td>
<td width="60%">
This exception represents any floating-point exception not included in this list.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_FLT_OVERFLOW"></a><a id="exception_flt_overflow"></a><dl>
<dt><b>EXCEPTION_FLT_OVERFLOW</b></dt>
</dl>
</td>
<td width="60%">
The exponent of a floating-point operation is greater than the magnitude allowed by the corresponding type.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_FLT_STACK_CHECK"></a><a id="exception_flt_stack_check"></a><dl>
<dt><b>EXCEPTION_FLT_STACK_CHECK</b></dt>
</dl>
</td>
<td width="60%">
The stack overflowed or underflowed as the result of a floating-point operation.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_FLT_UNDERFLOW"></a><a id="exception_flt_underflow"></a><dl>
<dt><b>EXCEPTION_FLT_UNDERFLOW</b></dt>
</dl>
</td>
<td width="60%">
The exponent of a floating-point operation is less than the magnitude allowed by the corresponding type.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_ILLEGAL_INSTRUCTION"></a><a id="exception_illegal_instruction"></a><dl>
<dt><b>EXCEPTION_ILLEGAL_INSTRUCTION</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to execute an invalid instruction.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_IN_PAGE_ERROR"></a><a id="exception_in_page_error"></a><dl>
<dt><b>EXCEPTION_IN_PAGE_ERROR</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to access a page that was not present, and the system was unable to load the page. For example, this exception might occur if a network connection is lost while running a program over the network.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_INT_DIVIDE_BY_ZERO"></a><a id="exception_int_divide_by_zero"></a><dl>
<dt><b>EXCEPTION_INT_DIVIDE_BY_ZERO</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to divide an integer value by an integer divisor of zero.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_INT_OVERFLOW"></a><a id="exception_int_overflow"></a><dl>
<dt><b>EXCEPTION_INT_OVERFLOW</b></dt>
</dl>
</td>
<td width="60%">
The result of an integer operation caused a carry out of the most significant bit of the result.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_INVALID_DISPOSITION"></a><a id="exception_invalid_disposition"></a><dl>
<dt><b>EXCEPTION_INVALID_DISPOSITION</b></dt>
</dl>
</td>
<td width="60%">
An exception handler returned an invalid disposition to the exception dispatcher. Programmers using a high-level language such as C should never encounter this exception.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_NONCONTINUABLE_EXCEPTION"></a><a id="exception_noncontinuable_exception"></a><dl>
<dt><b>EXCEPTION_NONCONTINUABLE_EXCEPTION</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to continue execution after a noncontinuable exception occurred.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_PRIV_INSTRUCTION"></a><a id="exception_priv_instruction"></a><dl>
<dt><b>EXCEPTION_PRIV_INSTRUCTION</b></dt>
</dl>
</td>
<td width="60%">
The thread tried to execute an instruction whose operation is not allowed in the current machine mode.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_SINGLE_STEP"></a><a id="exception_single_step"></a><dl>
<dt><b>EXCEPTION_SINGLE_STEP</b></dt>
</dl>
</td>
<td width="60%">
A trace trap or other single-instruction mechanism signaled that one instruction has been executed.

</td>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_STACK_OVERFLOW"></a><a id="exception_stack_overflow"></a><dl>
<dt><b>EXCEPTION_STACK_OVERFLOW</b></dt>
</dl>
</td>
<td width="60%">
The thread used up its stack.

</td>
</tr>
</table>
 

Another exception code is likely to occur when debugging console processes. It does not arise because of a programming error. The DBG_CONTROL_C exception code occurs when CTRL+C is input to a console process that handles CTRL+C signals and is being debugged. This exception code is not meant to be handled by applications. It is raised only for the benefit of the debugger, and is raised only when a debugger is attached to the console process.


### -field ExceptionFlags

This member can be either zero, indicating a continuable exception, or EXCEPTION_NONCONTINUABLE, indicating a noncontinuable exception. Any attempt to continue execution after a noncontinuable exception causes the EXCEPTION_NONCONTINUABLE_EXCEPTION exception.


### -field ExceptionRecord

A pointer to an associated 
<b>MINIDUMP_EXCEPTION</b> structure. Exception records can be chained together to provide additional information when nested exceptions occur.


### -field ExceptionAddress

The address where the exception occurred.


### -field NumberParameters

The number of parameters associated with the exception. This is the number of defined elements in the <b>ExceptionInformation</b> array.


### -field __unusedAlignment

Reserved for cross-platform structure member alignment. Do not set.


### -field ExceptionInformation

An array of additional arguments that describe the exception. The 
<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-raiseexception">RaiseException</a> function can specify this array of arguments. For most exception codes, the array elements are undefined. For the following exception code, the array elements are defined as follows. 



<table>
<tr>
<th>Exception code</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="EXCEPTION_ACCESS_VIOLATION"></a><a id="exception_access_violation"></a><dl>
<dt><b>EXCEPTION_ACCESS_VIOLATION</b></dt>
</dl>
</td>
<td width="60%">
The first element of the array contains a read/write flag that indicates the type of operation that caused the access violation. If this value is zero, the thread attempted to read the inaccessible data. If this value is 1, the thread attempted to write to an inaccessible address. 




The second array element specifies the virtual address of the inaccessible data.

</td>
</tr>
</table>
 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/minidumpapiset/ns-minidumpapiset-minidump_exception_stream">MINIDUMP_EXCEPTION_STREAM</a>



<a href="https://docs.microsoft.com/windows/desktop/api/errhandlingapi/nf-errhandlingapi-raiseexception">RaiseException</a>
 

 

