---
UID: NE:minwinbase._FILE_INFO_BY_HANDLE_CLASS
title: FILE_INFO_BY_HANDLE_CLASS (minwinbase.h)
description: Identifies the type of file information that GetFileInformationByHandleEx should retrieve or SetFileInformationByHandle should set.
old-location: fs\file_info_by_handle_class.htm
tech.root: FileIO
ms.assetid: 8f02e824-ca41-48c1-a5e8-5b12d81886b5
ms.date: 12/05/2018
ms.keywords: '*PFILE_INFO_BY_HANDLE_CLASS, FILE_INFO_BY_HANDLE_CLASS, FILE_INFO_BY_HANDLE_CLASS enumeration [Files], FileAlignmentInfo, FileAllocationInfo, FileAttributeTagInfo, FileBasicInfo, FileCompressionInfo, FileDispositionInfo, FileEndOfFileInfo, FileFullDirectoryInfo, FileFullDirectoryRestartInfo, FileIdBothDirectoryInfo, FileIdBothDirectoryRestartInfo, FileIdExtdDirectoryInfo, FileIdExtdDirectoryRestartInfo, FileIdInfo, FileIoPriorityHintInfo, FileNameInfo, FileRemoteProtocolInfo, FileRenameInfo, FileStandardInfo, FileStorageInfo, FileStreamInfo, MaximumFileInfoByHandlesClass, PFILE_INFO_BY_HANDLE_CLASS, PFILE_INFO_BY_HANDLE_CLASS enumeration pointer [Files], fileextd/FILE_INFO_BY_HANDLE_CLASS, fileextd/FileAlignmentInfo, fileextd/FileAllocationInfo, fileextd/FileAttributeTagInfo, fileextd/FileBasicInfo, fileextd/FileCompressionInfo, fileextd/FileDispositionInfo, fileextd/FileEndOfFileInfo, fileextd/FileFullDirectoryInfo, fileextd/FileFullDirectoryRestartInfo, fileextd/FileIdBothDirectoryInfo, fileextd/FileIdBothDirectoryRestartInfo, fileextd/FileIdExtdDirectoryInfo, fileextd/FileIdExtdDirectoryRestartInfo, fileextd/FileIdInfo, fileextd/FileIoPriorityHintInfo, fileextd/FileNameInfo, fileextd/FileRemoteProtocolInfo, fileextd/FileRenameInfo, fileextd/FileStandardInfo, fileextd/FileStorageInfo, fileextd/FileStreamInfo, fileextd/MaximumFileInfoByHandlesClass, fileextd/PFILE_INFO_BY_HANDLE_CLASS, fs.file_info_by_handle_class, minwinbase/FILE_INFO_BY_HANDLE_CLASS, minwinbase/FileAlignmentInfo, minwinbase/FileAllocationInfo, minwinbase/FileAttributeTagInfo, minwinbase/FileBasicInfo, minwinbase/FileCompressionInfo, minwinbase/FileDispositionInfo, minwinbase/FileEndOfFileInfo, minwinbase/FileFullDirectoryInfo, minwinbase/FileFullDirectoryRestartInfo, minwinbase/FileIdBothDirectoryInfo, minwinbase/FileIdBothDirectoryRestartInfo, minwinbase/FileIdExtdDirectoryInfo, minwinbase/FileIdExtdDirectoryRestartInfo, minwinbase/FileIdInfo, minwinbase/FileIoPriorityHintInfo, minwinbase/FileNameInfo, minwinbase/FileRemoteProtocolInfo, minwinbase/FileRenameInfo, minwinbase/FileStandardInfo, minwinbase/FileStorageInfo, minwinbase/FileStreamInfo, minwinbase/MaximumFileInfoByHandlesClass, minwinbase/PFILE_INFO_BY_HANDLE_CLASS'
f1_keywords:
- minwinbase/FILE_INFO_BY_HANDLE_CLASS
dev_langs:
- c++
req.header: minwinbase.h
req.include-header: Windows.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- MinWinBase.h
- FileExtd.h
api_name:
- FILE_INFO_BY_HANDLE_CLASS
targetos: Windows
req.typenames: FILE_INFO_BY_HANDLE_CLASS, *PFILE_INFO_BY_HANDLE_CLASS
req.redist: Windows SDK on     Windows Server 2003 and Windows XP.
ms.custom: 19H1
---

# FILE_INFO_BY_HANDLE_CLASS enumeration


## -description


Identifies the type  of file information that 
   <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a> should retrieve 
   or <a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-setfileinformationbyhandle">SetFileInformationByHandle</a> should 
   set.


## -enum-fields




### -field FileBasicInfo

Minimal information for the file should be retrieved or set. Used for file handles. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_basic_info">FILE_BASIC_INFO</a>.


### -field FileStandardInfo

Extended information for the file should be retrieved. Used for file handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_standard_info">FILE_STANDARD_INFO</a>.


### -field FileNameInfo

The file name should be retrieved. Used for any handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_name_info">FILE_NAME_INFO</a>.


### -field FileRenameInfo

The file name should be changed. Used for file handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-setfileinformationbyhandle">SetFileInformationByHandle</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_rename_info">FILE_RENAME_INFO</a>.


### -field FileDispositionInfo

The file should be deleted. Used for any handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-setfileinformationbyhandle">SetFileInformationByHandle</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_disposition_info">FILE_DISPOSITION_INFO</a>.


### -field FileAllocationInfo

The file allocation information should be changed. Used for file handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-setfileinformationbyhandle">SetFileInformationByHandle</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_allocation_info">FILE ALLOCATION INFO</a>.


### -field FileEndOfFileInfo

The end of the file should be set. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-setfileinformationbyhandle">SetFileInformationByHandle</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_end_of_file_info">FILE_END_OF_FILE_INFO</a>.


### -field FileStreamInfo

File stream information for the specified file should be retrieved. Used for any handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_stream_info">FILE_STREAM_INFO</a>.


### -field FileCompressionInfo

File compression information should be retrieved. Used for any handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_compression_info">FILE_COMPRESSION_INFO</a>.


### -field FileAttributeTagInfo

File attribute information should be retrieved. Used for any handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_attribute_tag_info">FILE_ATTRIBUTE_TAG_INFO</a>.


### -field FileIdBothDirectoryInfo

Files in the specified directory should be retrieved. Used for directory handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. The number 
      of files returned for each call to 
      <b>GetFileInformationByHandleEx</b> depends on 
      the size of the buffer that is passed to the function. Any subsequent calls to 
      <b>GetFileInformationByHandleEx</b> on the same 
      handle will resume the enumeration operation after the last file is returned. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_id_both_dir_info">FILE_ID_BOTH_DIR_INFO</a>.


### -field FileIdBothDirectoryRestartInfo

Identical to <b>FileIdBothDirectoryInfo</b>, but forces the enumeration operation to 
      start again from the beginning. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_id_both_dir_info">FILE_ID_BOTH_DIR_INFO</a>.


### -field FileIoPriorityHintInfo

Priority hint information should be  set. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-setfileinformationbyhandle">SetFileInformationByHandle</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_io_priority_hint_info">FILE_IO_PRIORITY_HINT_INFO</a>.


### -field FileRemoteProtocolInfo

File remote protocol information should be retrieved. Use for any handles. Use only when calling 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
      <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_remote_protocol_info">FILE_REMOTE_PROTOCOL_INFO</a>.


### -field FileFullDirectoryInfo

Files in the specified directory should be retrieved. Used for directory handles. Use only when calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_full_dir_info">FILE_FULL_DIR_INFO</a>.

<b>Windows Server 2008 R2, Windows 7, Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This value is not supported before Windows 8 and Windows Server 2012


### -field FileFullDirectoryRestartInfo

Identical to <b>FileFullDirectoryInfo</b>, but forces the enumeration operation to 
       start again from the beginning. Use only when calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_full_dir_info">FILE_FULL_DIR_INFO</a>.

<b>Windows Server 2008 R2, Windows 7, Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This value is not supported before Windows 8 and Windows Server 2012


### -field FileStorageInfo

File storage information should be retrieved. Use for any handles. Use only when calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_storage_info">FILE_STORAGE_INFO</a>.

<b>Windows Server 2008 R2, Windows 7, Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This value is not supported before Windows 8 and Windows Server 2012


### -field FileAlignmentInfo

File alignment information should be retrieved. Use for any handles. Use only when calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_alignment_info">FILE_ALIGNMENT_INFO</a>.

<b>Windows Server 2008 R2, Windows 7, Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This value is not supported before Windows 8 and Windows Server 2012


### -field FileIdInfo

File information should be retrieved. Use for any handles. Use only when calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_id_info">FILE_ID_INFO</a>.

<b>Windows Server 2008 R2, Windows 7, Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This value is not supported before Windows 8 and Windows Server 2012


### -field FileIdExtdDirectoryInfo

Files in the specified directory should be retrieved. Used for directory handles. Use only when calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_id_extd_dir_info">FILE_ID_EXTD_DIR_INFO</a>.

<b>Windows Server 2008 R2, Windows 7, Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This value is not supported before Windows 8 and Windows Server 2012


### -field FileIdExtdDirectoryRestartInfo

Identical to <b>FileIdExtdDirectoryInfo</b>, but forces the enumeration operation to 
       start again from the beginning. Use only when calling 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. See 
       <a href="https://docs.microsoft.com/windows/desktop/api/winbase/ns-winbase-file_id_extd_dir_info">FILE_ID_EXTD_DIR_INFO</a>.

<b>Windows Server 2008 R2, Windows 7, Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This value is not supported before Windows 8 and Windows Server 2012


### -field FileDispositionInfoEx


### -field FileRenameInfoEx


### -field MaximumFileInfoByHandleClass




#### - MaximumFileInfoByHandlesClass

This value is used for validation. Supported values are less than this value.


## -remarks



As noted in the preceding section, some file information classes are valid only for use with 
    <a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>. Others are 
    valid only for use with 
    <a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-setfileinformationbyhandle">SetFileInformationByHandle</a>. Where neither 
    function is mentioned, the information class is valid with both functions.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winbase/nf-winbase-getfileinformationbyhandleex">GetFileInformationByHandleEx</a>



<a href="https://docs.microsoft.com/windows/desktop/api/fileapi/nf-fileapi-setfileinformationbyhandle">SetFileInformationByHandle</a>
 

 

