---
UID: NF:mmc.IControlbar.Create
title: IControlbar::Create (mmc.h)
description: The IControlbar::Create method creates and returns the control requested by the snap-in.
old-location: mmc\icontrolbar_create.htm
tech.root: mmc
ms.assetid: 2ce92539-f5dc-44c3-94e5-253fc9995932
ms.date: 12/05/2018
ms.keywords: Create, Create method [MMC], Create method [MMC],IControlbar interface, IControlbar interface [MMC],Create method, IControlbar.Create, IControlbar::Create, _slate_icontrolbar_create, mmc.icontrolbar_create, mmc/IControlbar::Create
f1_keywords:
- mmc/IControlbar.Create
dev_langs:
- c++
req.header: mmc.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Mmcndmgr.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Mmcndmgr.dll
api_name:
- IControlbar.Create
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IControlbar::Create


## -description


The <b>IControlbar::Create</b> method creates and returns the control requested by the snap-in.


## -parameters




### -param nType [in]

A value that specifies the type of control to be associated; taken from the 
<a href="https://docs.microsoft.com/windows/desktop/api/mmc/ne-mmc-mmc_control_type">MMC_CONTROL_TYPE</a> enumeration.


### -param pExtendControlbar [in]

A pointer to the snap-in's 
<a href="https://docs.microsoft.com/windows/desktop/api/mmc/nn-mmc-iextendcontrolbar">IExtendControlbar</a> interface that is to be associated with the control (toolbar or menu button) that will be created. Notifications generated by the new control will be sent to 
<a href="https://docs.microsoft.com/windows/desktop/api/mmc/nf-mmc-iextendcontrolbar-controlbarnotify">IExtendControlBar::ControlbarNotify</a>.


### -param ppUnknown [out]

A pointer to the address of the IUnknown interface of the control that was created.


## -returns



This method can return one of these values.




## -remarks



The <b>IControlbar::Create</b> method increments the reference count on the control bar object it creates, so the snap-in is not required to call the AddRef method on the interface.

Although COMBOBOXBAR is included in Mmc.idl in connection with the nType parameter, it is not implemented.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mmc/nn-mmc-itoolbar">IToolbar</a>
 

 

