---
UID: NE:mmcobj.ColumnSortOrder
title: _ColumnSortOrder (mmcobj.h)
description: Used by IResultsViewer::SortOrderProperty to indicate or set how a query is to be sorted.
old-location: lwef\search_2x_columnsortorder.htm
tech.root: lwef
ms.assetid: VS|search|~\search\wds2x\reference\enum\columnsortorder.htm
ms.date: 12/05/2018
ms.keywords: AscItems, COLUMNSORTORDER, ColumnSortOrder, ColumnSortOrder enumeration [Legacy Windows Environment Features], DescItems, _ColumnSortOrder, lwef.search_2x_columnsortorder, mmcobj/AscItems, mmcobj/ColumnSortOrder, mmcobj/DescItems, search.search_2x_columnsortorder, search_2x_ColumnSortOrder
f1_keywords:
- mmcobj/ColumnSortOrder
dev_langs:
- c++
req.header: mmcobj.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mmcobj.h
api_name:
- ColumnSortOrder
targetos: Windows
req.typenames: _ColumnSortOrder, COLUMNSORTORDER
req.redist: 
ms.custom: 19H1
---

# _ColumnSortOrder enumeration


## -description


<p class="CCE_Message">[Windows Search 2.x is available for use in the operating system specified in the 

Requirements section. It might be altered or unavailable in later versions. Use the <a href="https://docs.microsoft.com/windows/desktop/search/-search-reference-entry-page">Windows Search API</a> instead.]

Used by <a href="https://docs.microsoft.com/windows/desktop/lwef/-search-2x-iresultsviewer-sortorderproperty">IResultsViewer::SortOrderProperty</a> to indicate or set how a query is to be sorted.


## -enum-fields




### -field SortOrder_Ascending


### -field SortOrder_Descending




#### - AscItems

Indicates that the sort order is ascending.


#### - DescItems

Indicates that the sort order is descending.

