---
UID: NS:mmreg.mpeglayer3waveformat_tag
title: MPEGLAYER3WAVEFORMAT (mmreg.h)
description: The MPEGLAYER3WAVEFORMAT structure describes an MPEG Audio Layer-3 (MP3) audio format.
old-location: dshow\mpeglayer3waveformat.htm
tech.root: DirectShow
ms.assetid: eca403a0-01a2-4290-951f-a7d516a58b9e
ms.date: 12/05/2018
ms.keywords: '*LPMPEGLAYER3WAVEFORMAT, *NPMPEGLAYER3WAVEFORMAT, *PMPEGLAYER3WAVEFORMAT, MPEGLAYER3WAVEFORMAT, MPEGLAYER3WAVEFORMAT structure [DirectShow], MPEGLAYER3WAVEFORMATStructure, MPEGLAYER3_FLAG_PADDING_ISO, MPEGLAYER3_FLAG_PADDING_OFF, MPEGLAYER3_FLAG_PADDING_ON, dshow.mpeglayer3waveformat, mmreg/MPEGLAYER3WAVEFORMAT, mpeglayer3waveformat_tag'
f1_keywords:
- mmreg/MPEGLAYER3WAVEFORMAT
dev_langs:
- c++
req.header: mmreg.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- mmreg.h
api_name:
- MPEGLAYER3WAVEFORMAT
targetos: Windows
req.typenames: MPEGLAYER3WAVEFORMAT
req.redist: 
ms.custom: 19H1
---

# MPEGLAYER3WAVEFORMAT structure


## -description


The <b>MPEGLAYER3WAVEFORMAT</b> structure describes an MPEG Audio Layer-3 (MP3) audio format.
        


## -struct-fields




### -field wfx


<a href="https://docs.microsoft.com/previous-versions/dd757713(v=vs.85)">WAVEFORMATEX</a> structure that specifies the basic audio format. The <b>wFormatTag</b> member must be <b>WAVE_FORMAT_MPEGLAYER3</b>. The <b>cbSize</b> member must be at least 12. (For <b>cbSize</b>, you can use the constant <b>MPEGLAYER3_WFX_EXTRA_BYTES</b>, defined in the Mmreg.h.)


### -field wID

Set this structure member to <b>MPEGLAYER3_ID_MPEG</b>.
          


### -field fdwFlags

Indicates whether padding is used to adjust the average bitrate to the sampling rate. Use one of the following values:

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="MPEGLAYER3_FLAG_PADDING_ISO"></a><a id="mpeglayer3_flag_padding_iso"></a><dl>
<dt><b>MPEGLAYER3_FLAG_PADDING_ISO</b></dt>
<dt>0x00000000</dt>
</dl>
</td>
<td width="60%">
Insert padding as needed to achieve the stated average bitrate.

</td>
</tr>
<tr>
<td width="40%"><a id="MPEGLAYER3_FLAG_PADDING_ON"></a><a id="mpeglayer3_flag_padding_on"></a><dl>
<dt><b>MPEGLAYER3_FLAG_PADDING_ON</b></dt>
<dt>0x00000001</dt>
</dl>
</td>
<td width="60%">
Always insert padding. The average bit rate may be higher than stated.

</td>
</tr>
<tr>
<td width="40%"><a id="MPEGLAYER3_FLAG_PADDING_OFF"></a><a id="mpeglayer3_flag_padding_off"></a><dl>
<dt><b>MPEGLAYER3_FLAG_PADDING_OFF</b></dt>
<dt>0x00000002</dt>
</dl>
</td>
<td width="60%">
Never insert padding. The average bit rate may be lower than stated.

</td>
</tr>
</table>
 


### -field nBlockSize

Block size in bytes. This value equals the frame length in bytes x <b>nFramesPerBlock</b>. For MP3 audio, the frame length is calculated as follows: 144 x (bitrate / sample rate) + padding.


### -field nFramesPerBlock

Number of audio frames per block.


### -field nCodecDelay

Encoder delay in samples. If you do not know this value, set this structure member to zero.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/directshow-structures">DirectShow Structures</a>
 

 

