---
UID: NF:mpconfig.IMixerPinConfig.SetRelativePosition
title: IMixerPinConfig::SetRelativePosition (mpconfig.h)
description: The SetRelativePosition method sets the position of the stream in the display window.
old-location: dshow\imixerpinconfig_setrelativeposition.htm
tech.root: DirectShow
ms.assetid: 2b8ff58b-04df-4a6a-b501-f5c138b8abbf
ms.date: 12/05/2018
ms.keywords: IMixerPinConfig interface [DirectShow],SetRelativePosition method, IMixerPinConfig.SetRelativePosition, IMixerPinConfig::SetRelativePosition, IMixerPinConfigSetRelativePosition, SetRelativePosition, SetRelativePosition method [DirectShow], SetRelativePosition method [DirectShow],IMixerPinConfig interface, dshow.imixerpinconfig_setrelativeposition, mpconfig/IMixerPinConfig::SetRelativePosition
f1_keywords:
- mpconfig/IMixerPinConfig.SetRelativePosition
dev_langs:
- c++
req.header: mpconfig.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Strmiids.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Strmiids.lib
- Strmiids.dll
api_name:
- IMixerPinConfig.SetRelativePosition
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IMixerPinConfig::SetRelativePosition


## -description



The <code>SetRelativePosition</code> method sets the position of the stream in the display window.




## -parameters




### -param dwLeft [in]

Value specifying the x-coordinate in the upper-left corner of the display window.


### -param dwTop [in]

Value specifying the y-coordinate in the upper-left corner of the display window.


### -param dwRight [in]

Value specifying the x-coordinate in the bottom-right corner of the display window.


### -param dwBottom [in]

Value specifying the y-coordinate in the bottom-right corner of the display window.


## -returns



Returns an <b>HRESULT</b> value. Possible values include the following:

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
Coordinates not in the {0, 0, 10,000, 10,000} range.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
Success.

</td>
</tr>
</table>
 




## -remarks



This method assumes window coordinates of {0, 0, 10,000, 10,000}. Therefore, if you want your video stream to be rendered in the bottom right quarter of the display window, you would call this method with the parameters {5,000, 5,000, 10,000, 10,000}.

<div class="alert"><b>Note</b>  Values greater than 10,000 are invalid and will cause an error.</div>
<div> </div>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/error-and-success-codes">Error and Success Codes</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mpconfig/nn-mpconfig-imixerpinconfig">IMixerPinConfig Interface</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mpconfig/nf-mpconfig-imixerpinconfig-getrelativeposition">IMixerPinConfig::GetRelativePosition</a>
 

 

