---
UID: NE:mprapi._RAS_HARDWARE_CONDITION
title: RAS_HARDWARE_CONDITION (mprapi.h)
description: The RAS_HARDWARE_CONDITION enumeration type specifies hardware status information about a given RAS port.
old-location: rras\ras_hardware_condition.htm
tech.root: RRAS
ms.assetid: 54a92552-9ad2-4a4a-b177-041157b445cd
ms.date: 12/05/2018
ms.keywords: RAS_HARDWARE_CONDITION, RAS_HARDWARE_CONDITION enumeration [RAS], RAS_HARDWARE_FAILURE, RAS_HARDWARE_OPERATIONAL, _mpr_ras_hardware_condition, mprapi/RAS_HARDWARE_CONDITION, mprapi/RAS_HARDWARE_FAILURE, mprapi/RAS_HARDWARE_OPERATIONAL, rras.ras_hardware_condition
f1_keywords:
- mprapi/RAS_HARDWARE_CONDITION
dev_langs:
- c++
req.header: mprapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Mprapi.h
api_name:
- RAS_HARDWARE_CONDITION
targetos: Windows
req.typenames: RAS_HARDWARE_CONDITION
req.redist: 
ms.custom: 19H1
---

# RAS_HARDWARE_CONDITION enumeration


## -description


The 
<b>RAS_HARDWARE_CONDITION</b> enumeration type specifies hardware status information about a given RAS port.


## -enum-fields




### -field RAS_HARDWARE_OPERATIONAL

The port is operational.


### -field RAS_HARDWARE_FAILURE

The port is not operational, due to a hardware failure.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/RRAS/ras-administration-enumerations">RAS Administration Enumerated Types</a>



<a href="https://docs.microsoft.com/windows/desktop/RRAS/remote-access-service-administration-reference">Remote Access Service Administration Reference</a>
 

 

