---
UID: NF:mprapi.MprConfigBufferFree
title: MprConfigBufferFree function (mprapi.h)
description: The MprConfigBufferFree function frees buffers. MprConfigXEnum, MprConfigXGetInfo
old-location: rras\mprconfigbufferfree.htm
tech.root: RRAS
ms.assetid: d7df56ee-72e4-4b0c-87a3-a1f66d791b62
ms.date: 12/05/2018
ms.keywords: MprConfigBufferFree, MprConfigBufferFree function [RAS], _mpr_mprconfigbufferfree, mprapi/MprConfigBufferFree, rras.mprconfigbufferfree
f1_keywords:
- mprapi/MprConfigBufferFree
dev_langs:
- c++
req.header: mprapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Mprapi.lib
req.dll: Mprapi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Mprapi.dll
api_name:
- MprConfigBufferFree
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# MprConfigBufferFree function


## -description


The 
<b>MprConfigBufferFree</b> function frees buffers allocated by calls to the following functions:

MprConfigXEnum
			

MprConfigXGetInfo
			

where X stands for Server, 
<a href="https://docs.microsoft.com/windows/desktop/RRAS/interface">Interface</a>, Transport, or InterfaceTransport.


## -parameters




### -param pBuffer [in]

Pointer to a memory buffer allocated by a previous call to: 




MprConfigXEnum
						

MprConfigXGetInfo
						

where X stands for Server, 
<a href="https://docs.microsoft.com/windows/desktop/RRAS/interface">Interface</a>, Transport, or InterfaceTransport.


## -returns



If the function succeeds, the return value is NO_ERROR.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mprapi/nf-mprapi-mprconfiginterfaceenum">MprConfigInterfaceEnum</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mprapi/nf-mprapi-mprconfiginterfacegetinfo">MprConfigInterfaceGetInfo</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mprapi/nf-mprapi-mprconfiginterfacetransportenum">MprConfigInterfaceTransportEnum</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mprapi/nf-mprapi-mprconfiginterfacetransportgetinfo">MprConfigInterfaceTransportGetInfo</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mprapi/nf-mprapi-mprconfigservergetinfo">MprConfigServerGetInfo</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mprapi/nf-mprapi-mprconfigtransportenum">MprConfigTransportEnum</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mprapi/nf-mprapi-mprconfigtransportgetinfo">MprConfigTransportGetInfo</a>



<a href="https://docs.microsoft.com/windows/desktop/RRAS/router-configuration-functions">Router Configuration Functions</a>



<a href="https://docs.microsoft.com/windows/desktop/RRAS/router-management-reference">Router Management Reference</a>
 

 

