---
UID: NE:msclus.CLUS_CHARACTERISTICS
title: CLUS_CHARACTERISTICS (msclus.h)
description: Enumerates characteristics of resource types and resources.
old-location: mscs\clus_characteristics.htm
tech.root: MsCS
ms.assetid: d55506fe-57d7-4d33-a28c-b185f508167d
ms.date: 12/05/2018
ms.keywords: CLUS_CHARACTERISTICS, CLUS_CHARACTERISTICS enumeration [Failover Cluster], CLUS_CHAR_BROADCAST_DELETE, CLUS_CHAR_CLONES, CLUS_CHAR_COEXIST_IN_SHARED_VOLUME_GROUP, CLUS_CHAR_DELETE_REQUIRES_ALL_NODES, CLUS_CHAR_INFRASTRUCTURE, CLUS_CHAR_LOCAL_QUORUM, CLUS_CHAR_LOCAL_QUORUM_DEBUG, CLUS_CHAR_MONITOR_DETACH, CLUS_CHAR_MONITOR_REATTACH, CLUS_CHAR_NOTIFY_NEW_OWNER, CLUS_CHAR_NOT_PREEMPTABLE, CLUS_CHAR_OPERATION_CONTEXT, CLUS_CHAR_PLACEMENT_DATA, CLUS_CHAR_QUORUM, CLUS_CHAR_REQUIRES_STATE_CHANGE_REASON, CLUS_CHAR_SINGLE_CLUSTER_INSTANCE, CLUS_CHAR_SINGLE_GROUP_INSTANCE, CLUS_CHAR_SUPPORTS_UNMONITORED_STATE, CLUS_CHAR_UNKNOWN, _CLUS_CHARACTERISTICS, _CLUS_CHARACTERISTICS enumeration [Failover Cluster], clusapi/CLUS_CHARACTERISTICS, clusapi/CLUS_CHAR_BROADCAST_DELETE, clusapi/CLUS_CHAR_CLONES, clusapi/CLUS_CHAR_COEXIST_IN_SHARED_VOLUME_GROUP, clusapi/CLUS_CHAR_DELETE_REQUIRES_ALL_NODES, clusapi/CLUS_CHAR_INFRASTRUCTURE, clusapi/CLUS_CHAR_LOCAL_QUORUM, clusapi/CLUS_CHAR_LOCAL_QUORUM_DEBUG, clusapi/CLUS_CHAR_MONITOR_DETACH, clusapi/CLUS_CHAR_MONITOR_REATTACH, clusapi/CLUS_CHAR_NOTIFY_NEW_OWNER, clusapi/CLUS_CHAR_NOT_PREEMPTABLE, clusapi/CLUS_CHAR_OPERATION_CONTEXT, clusapi/CLUS_CHAR_PLACEMENT_DATA, clusapi/CLUS_CHAR_QUORUM, clusapi/CLUS_CHAR_REQUIRES_STATE_CHANGE_REASON, clusapi/CLUS_CHAR_SINGLE_CLUSTER_INSTANCE, clusapi/CLUS_CHAR_SINGLE_GROUP_INSTANCE, clusapi/CLUS_CHAR_SUPPORTS_UNMONITORED_STATE, clusapi/CLUS_CHAR_UNKNOWN, clusapi/_CLUS_CHARACTERISTICS, msclus/CLUS_CHARACTERISTICS, msclus/CLUS_CHAR_BROADCAST_DELETE, msclus/CLUS_CHAR_CLONES, msclus/CLUS_CHAR_COEXIST_IN_SHARED_VOLUME_GROUP, msclus/CLUS_CHAR_DELETE_REQUIRES_ALL_NODES, msclus/CLUS_CHAR_INFRASTRUCTURE, msclus/CLUS_CHAR_LOCAL_QUORUM, msclus/CLUS_CHAR_LOCAL_QUORUM_DEBUG, msclus/CLUS_CHAR_MONITOR_DETACH, msclus/CLUS_CHAR_MONITOR_REATTACH, msclus/CLUS_CHAR_NOTIFY_NEW_OWNER, msclus/CLUS_CHAR_NOT_PREEMPTABLE, msclus/CLUS_CHAR_OPERATION_CONTEXT, msclus/CLUS_CHAR_PLACEMENT_DATA, msclus/CLUS_CHAR_QUORUM, msclus/CLUS_CHAR_REQUIRES_STATE_CHANGE_REASON, msclus/CLUS_CHAR_SINGLE_CLUSTER_INSTANCE, msclus/CLUS_CHAR_SINGLE_GROUP_INSTANCE, msclus/CLUS_CHAR_SUPPORTS_UNMONITORED_STATE, msclus/CLUS_CHAR_UNKNOWN, msclus/_CLUS_CHARACTERISTICS, mscs.clus_characteristics
f1_keywords:
- msclus/CLUS_CHARACTERISTICS
dev_langs:
- c++
req.header: msclus.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Datacenter, Windows Server 2008 Enterprise
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUS_CHARACTERISTICS
targetos: Windows
req.typenames: CLUS_CHARACTERISTICS
req.redist: 
ms.custom: 19H1
---

# CLUS_CHARACTERISTICS enumeration


## -description


Enumerates characteristics of resource types and resources.


## -enum-fields




### -field CLUS_CHAR_UNKNOWN

Resources of this type have no known characteristics.


### -field CLUS_CHAR_QUORUM

Resources of this type are capable of being the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/quorum-resource">quorum resource type</a> for a cluster.


### -field CLUS_CHAR_DELETE_REQUIRES_ALL_NODES

Resources of this type cannot be deleted unless all nodes are active.


### -field CLUS_CHAR_LOCAL_QUORUM

Not supported.


### -field CLUS_CHAR_LOCAL_QUORUM_DEBUG

Not supported.


### -field CLUS_CHAR_REQUIRES_STATE_CHANGE_REASON

The <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resource-dlls">resource DLL</a> will receive the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-state-change-reason">CLUSCTL_RESOURCE_STATE_CHANGE_REASON</a> 
       control code.


### -field CLUS_CHAR_BROADCAST_DELETE

Not supported.


### -field CLUS_CHAR_SINGLE_CLUSTER_INSTANCE

Only one instance of this resource type is allowed in a cluster.


### -field CLUS_CHAR_SINGLE_GROUP_INSTANCE

Only one instance of this resource type is allowed in a group.


### -field CLUS_CHAR_COEXIST_IN_SHARED_VOLUME_GROUP

The resource can be made part of a special group. Protocol version 2.0 servers do not support this value.


### -field CLUS_CHAR_PLACEMENT_DATA

The resource type can be queried to get more information about how many resources it uses. For example, in the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/virtual-machine">virtual machine</a> resource type, information is returned about how much memory is required for the virtual machine to be started.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported before Windows Server 2012.


### -field CLUS_CHAR_MONITOR_DETACH

The resource can be deleted without being taken offline. Protocol version 2.0 servers do not support this value.




### -field CLUS_CHAR_MONITOR_REATTACH

This value is reserved for local use and must be ignored by the client. Protocol version 2.0 servers do not support this value.


### -field CLUS_CHAR_OPERATION_CONTEXT

This value is reserved for local use and must be ignored by the client. Protocol version 2.0 servers do not support this value.


### -field CLUS_CHAR_CLONES

This value is reserved for local use and must be ignored by the client. Protocol version 2.0 servers do not support this value.


### -field CLUS_CHAR_NOT_PREEMPTABLE

The resource should not be preempted, even if the whole group is being preempted.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported before Windows Server 2012.


### -field CLUS_CHAR_NOTIFY_NEW_OWNER

The resource can receive a new owner.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported before Windows Server 2012 R2.


### -field CLUS_CHAR_SUPPORTS_UNMONITORED_STATE

The resource can continue run in an unmonitored state when it losses cluster membership.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported before Windows Server 2016.


### -field CLUS_CHAR_INFRASTRUCTURE

This value is reserved for infrastructure.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported before Windows Server 2016.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-group-get-characteristics">CLUSCTL_GROUP_GET_CHARACTERISTICS</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-netinterface-get-characteristics">CLUSCTL_NETINTERFACE_GET_CHARACTERISTICS</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-network-get-characteristics">CLUSCTL_NETWORK_GET_CHARACTERISTICS</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-node-get-characteristics">CLUSCTL_NODE_GET_CHARACTERISTICS</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-characteristics">CLUSCTL_RESOURCE_GET_CHARACTERISTICS</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-characteristics">CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>
 

 

