---
UID: NE:msclus.CLUSCTL_RESOURCE_TYPE_CODES
title: CLUSCTL_RESOURCE_TYPE_CODES (msclus.h)
description: Enumerates resource type control codes.
old-location: mscs\clusctl_resource_type_codes.htm
tech.root: MsCS
ms.assetid: c34eda93-9389-4bf0-9e8f-7a80f10a1081
ms.date: 12/05/2018
ms.keywords: CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS, CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY, CLUSCTL_RESOURCE_TYPE_CLUSTER_VERSION_CHANGED, CLUSCTL_RESOURCE_TYPE_CODES, CLUSCTL_RESOURCE_TYPE_CODES enumeration [Failover Cluster], CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES, CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_TYPE_EVICT_NODE, CLUSCTL_RESOURCE_TYPE_FIXUP_ON_UPGRADE, CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY, CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_PATH, CLUSCTL_RESOURCE_TYPE_GEN_SCRIPT_VALIDATE_PATH, CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT, CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS, CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO, CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES, CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS, CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS, CLUSCTL_RESOURCE_TYPE_GET_CRYPTO_CHECKPOINTS, CLUSCTL_RESOURCE_TYPE_GET_FLAGS, CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS, CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS, CLUSCTL_RESOURCE_TYPE_GET_REGISTRY_CHECKPOINTS, CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES, CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES, CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_TYPE_HOLD_IO, CLUSCTL_RESOURCE_TYPE_INSTALL_NODE, CLUSCTL_RESOURCE_TYPE_NETNAME_GET_OU_FOR_VCO, CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME, CLUSCTL_RESOURCE_TYPE_PREPARE_UPGRADE, CLUSCTL_RESOURCE_TYPE_QUERY_DELETE, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_INFO, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_PARTITION_INFO, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES, CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP, CLUSCTL_RESOURCE_TYPE_RESUME_IO, CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES, CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_TYPE_STARTING_PHASE1, CLUSCTL_RESOURCE_TYPE_STARTING_PHASE2, CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS, CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX, CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INT, CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID, CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS, CLUSCTL_RESOURCE_TYPE_STORAGE_GET_RESOURCEID, CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE, CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER, CLUSCTL_RESOURCE_TYPE_STORAGE_REMOVE_VM_OWNERSHIP, CLUSCTL_RESOURCE_TYPE_STORAGE_SYNC_CLUSDISK_DB, CLUSCTL_RESOURCE_TYPE_UNKNOWN, CLUSCTL_RESOURCE_TYPE_UPGRADE_COMPLETED, CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES, CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES, CLUSCTL_RESOURCE_TYPE_WITNESS_VALIDATE_PATH, _CLUSCTL_RESOURCE_TYPE_CODES, _CLUSCTL_RESOURCE_TYPE_CODES enumeration [Failover Cluster], clusapi/CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS, clusapi/CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY, clusapi/CLUSCTL_RESOURCE_TYPE_CLUSTER_VERSION_CHANGED, clusapi/CLUSCTL_RESOURCE_TYPE_CODES, clusapi/CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_EVICT_NODE, clusapi/CLUSCTL_RESOURCE_TYPE_FIXUP_ON_UPGRADE, clusapi/CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY, clusapi/CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_PATH, clusapi/CLUSCTL_RESOURCE_TYPE_GEN_SCRIPT_VALIDATE_PATH, clusapi/CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT, clusapi/CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS, clusapi/CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO, clusapi/CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS, clusapi/CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS, clusapi/CLUSCTL_RESOURCE_TYPE_GET_CRYPTO_CHECKPOINTS, clusapi/CLUSCTL_RESOURCE_TYPE_GET_FLAGS, clusapi/CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS, clusapi/CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS, clusapi/CLUSCTL_RESOURCE_TYPE_GET_REGISTRY_CHECKPOINTS, clusapi/CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES, clusapi/CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_HOLD_IO, clusapi/CLUSCTL_RESOURCE_TYPE_INSTALL_NODE, clusapi/CLUSCTL_RESOURCE_TYPE_NETNAME_GET_OU_FOR_VCO, clusapi/CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME, clusapi/CLUSCTL_RESOURCE_TYPE_PREPARE_UPGRADE, clusapi/CLUSCTL_RESOURCE_TYPE_QUERY_DELETE, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_INFO, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_PARTITION_INFO, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES, clusapi/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP, clusapi/CLUSCTL_RESOURCE_TYPE_RESUME_IO, clusapi/CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_STARTING_PHASE1, clusapi/CLUSCTL_RESOURCE_TYPE_STARTING_PHASE2, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INT, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_RESOURCEID, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_REMOVE_VM_OWNERSHIP, clusapi/CLUSCTL_RESOURCE_TYPE_STORAGE_SYNC_CLUSDISK_DB, clusapi/CLUSCTL_RESOURCE_TYPE_UNKNOWN, clusapi/CLUSCTL_RESOURCE_TYPE_UPGRADE_COMPLETED, clusapi/CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES, clusapi/CLUSCTL_RESOURCE_TYPE_WITNESS_VALIDATE_PATH, clusapi/_CLUSCTL_RESOURCE_TYPE_CODES, msclus/CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS, msclus/CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY, msclus/CLUSCTL_RESOURCE_TYPE_CLUSTER_VERSION_CHANGED, msclus/CLUSCTL_RESOURCE_TYPE_CODES, msclus/CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_EVICT_NODE, msclus/CLUSCTL_RESOURCE_TYPE_FIXUP_ON_UPGRADE, msclus/CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY, msclus/CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_PATH, msclus/CLUSCTL_RESOURCE_TYPE_GEN_SCRIPT_VALIDATE_PATH, msclus/CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT, msclus/CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS, msclus/CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO, msclus/CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS, msclus/CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS, msclus/CLUSCTL_RESOURCE_TYPE_GET_CRYPTO_CHECKPOINTS, msclus/CLUSCTL_RESOURCE_TYPE_GET_FLAGS, msclus/CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS, msclus/CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS, msclus/CLUSCTL_RESOURCE_TYPE_GET_REGISTRY_CHECKPOINTS, msclus/CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES, msclus/CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_HOLD_IO, msclus/CLUSCTL_RESOURCE_TYPE_INSTALL_NODE, msclus/CLUSCTL_RESOURCE_TYPE_NETNAME_GET_OU_FOR_VCO, msclus/CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME, msclus/CLUSCTL_RESOURCE_TYPE_PREPARE_UPGRADE, msclus/CLUSCTL_RESOURCE_TYPE_QUERY_DELETE, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_INFO, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_PARTITION_INFO, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES, msclus/CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP, msclus/CLUSCTL_RESOURCE_TYPE_RESUME_IO, msclus/CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_STARTING_PHASE1, msclus/CLUSCTL_RESOURCE_TYPE_STARTING_PHASE2, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INT, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_GET_RESOURCEID, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_REMOVE_VM_OWNERSHIP, msclus/CLUSCTL_RESOURCE_TYPE_STORAGE_SYNC_CLUSDISK_DB, msclus/CLUSCTL_RESOURCE_TYPE_UNKNOWN, msclus/CLUSCTL_RESOURCE_TYPE_UPGRADE_COMPLETED, msclus/CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES, msclus/CLUSCTL_RESOURCE_TYPE_WITNESS_VALIDATE_PATH, msclus/_CLUSCTL_RESOURCE_TYPE_CODES, mscs.clusctl_resource_type_codes
f1_keywords:
- msclus/CLUSCTL_RESOURCE_TYPE_CODES
dev_langs:
- c++
req.header: msclus.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Enterprise, Windows Server 2008 Datacenter
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUSCTL_RESOURCE_TYPE_CODES
targetos: Windows
req.typenames: CLUSCTL_RESOURCE_TYPE_CODES
req.redist: 
ms.custom: 19H1
---

# CLUSCTL_RESOURCE_TYPE_CODES enumeration


## -description


Enumerates <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resource-types">resource type</a>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/about-control-codes">control codes</a>.


## -enum-fields




### -field CLUSCTL_RESOURCE_TYPE_UNKNOWN

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-unknown">CLUSCTL_RESOURCE_TYPE_UNKNOWN</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-characteristics">CLUSCTL_RESOURCE_TYPE_GET_CHARACTERISTICS</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_FLAGS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-flags">CLUSCTL_RESOURCE_TYPE_GET_FLAGS</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-class-info">CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-required-dependencies">CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-arb-timeout">CLUSCTL_RESOURCE_TYPE_GET_ARB_TIMEOUT</a>.


### -field CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-enum-common-properties">CLUSCTL_RESOURCE_TYPE_ENUM_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-ro-common-properties">CLUSCTL_RESOURCE_TYPE_GET_RO_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-common-properties">CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-validate-common-properties">CLUSCTL_RESOURCE_TYPE_VALIDATE_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-set-common-properties">CLUSCTL_RESOURCE_TYPE_SET_COMMON_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-common-property-fmts">CLUSCTL_RESOURCE_TYPE_GET_COMMON_PROPERTY_FMTS</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-common-resource-property-fmts">CLUSCTL_RESOURCE_TYPE_GET_COMMON_RESOURCE_PROPERTY_FMTS</a>.


### -field CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-enum-private-properties">CLUSCTL_RESOURCE_TYPE_ENUM_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-ro-private-properties">CLUSCTL_RESOURCE_TYPE_GET_RO_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-private-properties">CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-set-private-properties">CLUSCTL_RESOURCE_TYPE_SET_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-validate-private-properties">CLUSCTL_RESOURCE_TYPE_VALIDATE_PRIVATE_PROPERTIES</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-private-property-fmts">CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_PROPERTY_FMTS</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-private-resource-property-fmts">CLUSCTL_RESOURCE_TYPE_GET_PRIVATE_RESOURCE_PROPERTY_FMTS</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_REGISTRY_CHECKPOINTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-registry-checkpoints">CLUSCTL_RESOURCE_TYPE_GET_REGISTRY_CHECKPOINTS</a>.


### -field CLUSCTL_RESOURCE_TYPE_GET_CRYPTO_CHECKPOINTS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-crypto-checkpoints">CLUSCTL_RESOURCE_TYPE_GET_CRYPTO_CHECKPOINTS</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-available-disks">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_SYNC_CLUSDISK_DB

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-sync-clusdisk-db">CLUSCTL_RESOURCE_TYPE_STORAGE_SYNC_CLUSDISK_DB</a>.


### -field CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-netname-validate-netname">CLUSCTL_RESOURCE_TYPE_NETNAME_VALIDATE_NETNAME</a>.


### -field CLUSCTL_RESOURCE_TYPE_NETNAME_GET_OU_FOR_VCO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-netname-get-ou-for-vco">CLUSCTL_RESOURCE_TYPE_NETNAME_GET_OU_FOR_VCO</a>.


### -field CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_PATH

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-gen-app-validate-path">CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_PATH</a>.


### -field CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-gen-app-validate-directory">CLUSCTL_RESOURCE_TYPE_GEN_APP_VALIDATE_DIRECTORY</a>.


### -field CLUSCTL_RESOURCE_TYPE_GEN_SCRIPT_VALIDATE_PATH

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-gen-script-validate-path">CLUSCTL_RESOURCE_TYPE_GEN_SCRIPT_VALIDATE_PATH</a>.


### -field CLUSCTL_RESOURCE_TYPE_QUERY_DELETE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-query-delete">CLUSCTL_RESOURCE_TYPE_QUERY_DELETE</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-driveletters">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DRIVELETTERS</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-available-disks-ex">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-remap-driveletter">CLUSCTL_RESOURCE_TYPE_STORAGE_REMAP_DRIVELETTER</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-diskid">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_DISKID</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_GET_RESOURCEID

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-resourceid">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_RESOURCEID</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-is-clusterable">CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CLUSTERABLE</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_REMOVE_VM_OWNERSHIP

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-remove-vm-ownership">CLUSCTL_RESOURCE_TYPE_STORAGE_REMOVE_VM_OWNERSHIP</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_IS_CSV_FILE


### -field CLUSCTL_RESOURCE_TYPE_WITNESS_VALIDATE_PATH

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-witness-validate-path">CLUSCTL_RESOURCE_TYPE_WITNESS_VALIDATE_PATH</a>.


### -field CLUSCTL_RESOURCE_TYPE_INSTALL_NODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-install-node">CLUSCTL_RESOURCE_TYPE_INSTALL_NODE</a>.


### -field CLUSCTL_RESOURCE_TYPE_EVICT_NODE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-evict-node">CLUSCTL_RESOURCE_TYPE_EVICT_NODE</a>.


### -field CLUSCTL_RESOURCE_TYPE_CLUSTER_VERSION_CHANGED

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-cluster-version-changed">CLUSCTL_RESOURCE_TYPE_CLUSTER_VERSION_CHANGED</a>.


### -field CLUSCTL_RESOURCE_TYPE_FIXUP_ON_UPGRADE

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-fixup-on-upgrade">CLUSCTL_RESOURCE_TYPE_FIXUP_ON_UPGRADE</a>.


### -field CLUSCTL_RESOURCE_TYPE_STARTING_PHASE1

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-starting-phase1">CLUSCTL_RESOURCE_TYPE_STARTING_PHASE1</a>.


### -field CLUSCTL_RESOURCE_TYPE_STARTING_PHASE2

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-starting-phase2">CLUSCTL_RESOURCE_TYPE_STARTING_PHASE2</a>.


### -field CLUSCTL_RESOURCE_TYPE_HOLD_IO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-hold-io">CLUSCTL_RESOURCE_TYPE_HOLD_IO</a>.


### -field CLUSCTL_RESOURCE_TYPE_RESUME_IO

See 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-resume-io">CLUSCTL_RESOURCE_TYPE_RESUME_IO</a>.


### -field CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INT

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-storage-get-available-disks-ex2-int">CLUSCTL_RESOURCE_TYPE_STORAGE_GET_AVAILABLE_DISKS_EX2_INT</a>.

<b>Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2012 R2.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-eligible-logdisks">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_LOGDISKS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-eligible-target-datadisks">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_TARGET_DATADISKS</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-eligible-source-datadisks">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_ELIGIBLE_SOURCE_DATADISKS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-replicated-disks">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_DISKS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-replica-volumes">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICA_VOLUMES</a>


<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-log-volume">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_VOLUME</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-resource-group">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_RESOURCE_GROUP</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_PARTITION_INFO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-replicated-partition-info">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_REPLICATED_PARTITION_INFO</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_INFO

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-replication-get-log-info">CLUSCTL_RESOURCE_TYPE_REPLICATION_GET_LOG_INFO</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cloud-witness-resource-type-validate-credentials">CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-cloud-witness-resource-type-validate-credentials-with-key">CLUSCTL_CLOUD_WITNESS_RESOURCE_TYPE_VALIDATE_CREDENTIALS_WITH_KEY</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_PREPARE_UPGRADE

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-prepare-upgrade">CLUSCTL_RESOURCE_TYPE_PREPARE_UPGRADE</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_UPGRADE_COMPLETED

See <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-upgrade-completed">CLUSCTL_RESOURCE_TYPE_UPGRADE_COMPLETED</a>.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This control code is not available before Windows Server 2016.




### -field CLUSCTL_RESOURCE_TYPE_NOTIFY_MONITOR_SHUTTING_DOWN




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resource-type-control-codes">Resource Type Control Codes</a>
 

 

