---
UID: NE:msclus.CLUSTER_CHANGE
title: CLUSTER_CHANGE (msclus.h)
description: Describes the type of notification returned.
old-location: mscs\cluster_change.htm
tech.root: MsCS
ms.assetid: d396d490-84d0-4bf8-9c0d-8597b3baf0ec
ms.date: 12/05/2018
ms.keywords: CLUSTER_CHANGE, CLUSTER_CHANGE enumeration [Failover Cluster], CLUSTER_CHANGE_ALL, CLUSTER_CHANGE_CLUSTER_PROPERTY, CLUSTER_CHANGE_CLUSTER_RECONNECT, CLUSTER_CHANGE_CLUSTER_STATE, CLUSTER_CHANGE_GROUP_ADDED, CLUSTER_CHANGE_GROUP_DELETED, CLUSTER_CHANGE_GROUP_PROPERTY, CLUSTER_CHANGE_GROUP_STATE, CLUSTER_CHANGE_HANDLE_CLOSE, CLUSTER_CHANGE_NETINTERFACE_ADDED, CLUSTER_CHANGE_NETINTERFACE_DELETED, CLUSTER_CHANGE_NETINTERFACE_PROPERTY, CLUSTER_CHANGE_NETINTERFACE_STATE, CLUSTER_CHANGE_NETWORK_ADDED, CLUSTER_CHANGE_NETWORK_DELETED, CLUSTER_CHANGE_NETWORK_PROPERTY, CLUSTER_CHANGE_NETWORK_STATE, CLUSTER_CHANGE_NODE_ADDED, CLUSTER_CHANGE_NODE_DELETED, CLUSTER_CHANGE_NODE_PROPERTY, CLUSTER_CHANGE_NODE_STATE, CLUSTER_CHANGE_QUORUM_STATE, CLUSTER_CHANGE_REGISTRY_ATTRIBUTES, CLUSTER_CHANGE_REGISTRY_NAME, CLUSTER_CHANGE_REGISTRY_SUBTREE, CLUSTER_CHANGE_REGISTRY_VALUE, CLUSTER_CHANGE_RESOURCE_ADDED, CLUSTER_CHANGE_RESOURCE_DELETED, CLUSTER_CHANGE_RESOURCE_PROPERTY, CLUSTER_CHANGE_RESOURCE_STATE, CLUSTER_CHANGE_RESOURCE_TYPE_ADDED, CLUSTER_CHANGE_RESOURCE_TYPE_DELETED, CLUSTER_CHANGE_RESOURCE_TYPE_PROPERTY, _CLUSTER_CHANGE, _CLUSTER_CHANGE enumeration [Failover Cluster], clusapi/CLUSTER_CHANGE, clusapi/CLUSTER_CHANGE_ALL, clusapi/CLUSTER_CHANGE_CLUSTER_PROPERTY, clusapi/CLUSTER_CHANGE_CLUSTER_RECONNECT, clusapi/CLUSTER_CHANGE_CLUSTER_STATE, clusapi/CLUSTER_CHANGE_GROUP_ADDED, clusapi/CLUSTER_CHANGE_GROUP_DELETED, clusapi/CLUSTER_CHANGE_GROUP_PROPERTY, clusapi/CLUSTER_CHANGE_GROUP_STATE, clusapi/CLUSTER_CHANGE_HANDLE_CLOSE, clusapi/CLUSTER_CHANGE_NETINTERFACE_ADDED, clusapi/CLUSTER_CHANGE_NETINTERFACE_DELETED, clusapi/CLUSTER_CHANGE_NETINTERFACE_PROPERTY, clusapi/CLUSTER_CHANGE_NETINTERFACE_STATE, clusapi/CLUSTER_CHANGE_NETWORK_ADDED, clusapi/CLUSTER_CHANGE_NETWORK_DELETED, clusapi/CLUSTER_CHANGE_NETWORK_PROPERTY, clusapi/CLUSTER_CHANGE_NETWORK_STATE, clusapi/CLUSTER_CHANGE_NODE_ADDED, clusapi/CLUSTER_CHANGE_NODE_DELETED, clusapi/CLUSTER_CHANGE_NODE_PROPERTY, clusapi/CLUSTER_CHANGE_NODE_STATE, clusapi/CLUSTER_CHANGE_QUORUM_STATE, clusapi/CLUSTER_CHANGE_REGISTRY_ATTRIBUTES, clusapi/CLUSTER_CHANGE_REGISTRY_NAME, clusapi/CLUSTER_CHANGE_REGISTRY_SUBTREE, clusapi/CLUSTER_CHANGE_REGISTRY_VALUE, clusapi/CLUSTER_CHANGE_RESOURCE_ADDED, clusapi/CLUSTER_CHANGE_RESOURCE_DELETED, clusapi/CLUSTER_CHANGE_RESOURCE_PROPERTY, clusapi/CLUSTER_CHANGE_RESOURCE_STATE, clusapi/CLUSTER_CHANGE_RESOURCE_TYPE_ADDED, clusapi/CLUSTER_CHANGE_RESOURCE_TYPE_DELETED, clusapi/CLUSTER_CHANGE_RESOURCE_TYPE_PROPERTY, clusapi/_CLUSTER_CHANGE, msclus/CLUSTER_CHANGE, msclus/CLUSTER_CHANGE_ALL, msclus/CLUSTER_CHANGE_CLUSTER_PROPERTY, msclus/CLUSTER_CHANGE_CLUSTER_RECONNECT, msclus/CLUSTER_CHANGE_CLUSTER_STATE, msclus/CLUSTER_CHANGE_GROUP_ADDED, msclus/CLUSTER_CHANGE_GROUP_DELETED, msclus/CLUSTER_CHANGE_GROUP_PROPERTY, msclus/CLUSTER_CHANGE_GROUP_STATE, msclus/CLUSTER_CHANGE_HANDLE_CLOSE, msclus/CLUSTER_CHANGE_NETINTERFACE_ADDED, msclus/CLUSTER_CHANGE_NETINTERFACE_DELETED, msclus/CLUSTER_CHANGE_NETINTERFACE_PROPERTY, msclus/CLUSTER_CHANGE_NETINTERFACE_STATE, msclus/CLUSTER_CHANGE_NETWORK_ADDED, msclus/CLUSTER_CHANGE_NETWORK_DELETED, msclus/CLUSTER_CHANGE_NETWORK_PROPERTY, msclus/CLUSTER_CHANGE_NETWORK_STATE, msclus/CLUSTER_CHANGE_NODE_ADDED, msclus/CLUSTER_CHANGE_NODE_DELETED, msclus/CLUSTER_CHANGE_NODE_PROPERTY, msclus/CLUSTER_CHANGE_NODE_STATE, msclus/CLUSTER_CHANGE_QUORUM_STATE, msclus/CLUSTER_CHANGE_REGISTRY_ATTRIBUTES, msclus/CLUSTER_CHANGE_REGISTRY_NAME, msclus/CLUSTER_CHANGE_REGISTRY_SUBTREE, msclus/CLUSTER_CHANGE_REGISTRY_VALUE, msclus/CLUSTER_CHANGE_RESOURCE_ADDED, msclus/CLUSTER_CHANGE_RESOURCE_DELETED, msclus/CLUSTER_CHANGE_RESOURCE_PROPERTY, msclus/CLUSTER_CHANGE_RESOURCE_STATE, msclus/CLUSTER_CHANGE_RESOURCE_TYPE_ADDED, msclus/CLUSTER_CHANGE_RESOURCE_TYPE_DELETED, msclus/CLUSTER_CHANGE_RESOURCE_TYPE_PROPERTY, msclus/_CLUSTER_CHANGE, mscs.cluster_change
f1_keywords:
- msclus/CLUSTER_CHANGE
dev_langs:
- c++
req.header: msclus.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Enterprise, Windows Server 2008 Datacenter
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUSTER_CHANGE
targetos: Windows
req.typenames: CLUSTER_CHANGE
req.redist: 
ms.custom: 19H1
---

# CLUSTER_CHANGE enumeration


## -description


Describes the type of notification returned. The 
    <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-getclusternotify">GetClusterNotify</a>, 
    <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-registerclusternotify">RegisterClusterNotify</a>, and 
    <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-createcluster">CreateCluster</a> functions use this enumeration.


## -enum-fields




### -field CLUSTER_CHANGE_NODE_STATE

The queue receives a notification when a node changes state. For a list of possible node state values, see 
       <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-getclusternodestate">GetClusterNodeState</a>.


### -field CLUSTER_CHANGE_NODE_DELETED

The queue receives a notification when a node is permanently removed from a cluster. A node can be 
       permanently deleted from an existing cluster with a call to the 
       <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-evictclusternode">EvictClusterNode</a> function.


### -field CLUSTER_CHANGE_NODE_ADDED

The queue receives a notification when a new <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/nodes">node</a> 
       is added to the cluster. A node can be added only when the Cluster service is initially installed on the 
       node.


### -field CLUSTER_CHANGE_NODE_PROPERTY

This notification is reserved for future use.


### -field CLUSTER_CHANGE_REGISTRY_NAME

The queue receives a notification when the name of a cluster database key has changed.


### -field CLUSTER_CHANGE_REGISTRY_ATTRIBUTES

The queue receives a notification when a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-database">cluster database</a> key's attributes are changed. The only 
       currently defined cluster database key attribute is its security descriptor, which can be changed with 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/nf-clusapi-clusterregsetkeysecurity">ClusterRegSetKeySecurity</a>.


### -field CLUSTER_CHANGE_REGISTRY_VALUE

The queue receives a notification when a value of the specified cluster database key is changed or deleted. 
       Cluster database values can be changed with the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/nf-clusapi-clusterregsetvalue">ClusterRegSetValue</a> function and deleted with the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/nf-clusapi-clusterregdeletevalue">ClusterRegDeleteValue</a> function.


### -field CLUSTER_CHANGE_REGISTRY_SUBTREE

Indicates that the other <b>CLUSTER_CHANGE_REGISTRY_*</b> events apply to the entire 
       cluster database. If this flag is not included, the events apply only to the specified key.


### -field CLUSTER_CHANGE_RESOURCE_STATE

The queue receives a notification when a resource changes state. For a list of the possible resource state 
       values, see <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-getclusterresourcestate">GetClusterResourceState</a>.


### -field CLUSTER_CHANGE_RESOURCE_DELETED

The queue receives a notification when a resource is deleted.


### -field CLUSTER_CHANGE_RESOURCE_ADDED

The queue receives a notification when a new 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resources">resource</a> is created in the cluster.


### -field CLUSTER_CHANGE_RESOURCE_PROPERTY

The queue receives a notification when the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resource-common-properties">properties</a>, 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resource-dependencies">dependencies</a>, or 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/p-gly">possible owner</a> nodes of a resource change.


### -field CLUSTER_CHANGE_GROUP_STATE

The queue receives a notification when a group changes state. For a list of the possible group state 
       values, see <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-getclustergroupstate">GetClusterGroupState</a>.


### -field CLUSTER_CHANGE_GROUP_DELETED

The queue receives a notification when an existing group is deleted.


### -field CLUSTER_CHANGE_GROUP_ADDED

The queue receives a notification when a new <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/groups">group</a> is created 
       in the cluster.


### -field CLUSTER_CHANGE_GROUP_PROPERTY

The queue receives a notification when the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/group-common-properties">properties</a> of a group change or when a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resources">resource</a> is added or removed from a group.


### -field CLUSTER_CHANGE_RESOURCE_TYPE_DELETED

The queue receives a notification when an existing resource type is deleted.


### -field CLUSTER_CHANGE_RESOURCE_TYPE_ADDED

The queue receives a notification when a new 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resource-types">resource type</a> is created in the cluster.


### -field CLUSTER_CHANGE_RESOURCE_TYPE_PROPERTY

The queue receives a notification when the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resource-common-properties">properties</a> of a resource type 
       change.


### -field CLUSTER_CHANGE_CLUSTER_RECONNECT

When generated by a client, this value indicates that the RPC connection to a server has been reconnected to another server for the specified cluster. When generated by the server, this value indicates that notification events were dropped by the server for the port.


### -field CLUSTER_CHANGE_NETWORK_STATE

The queue receives a notification when a network changes state. For a list of the possible network state 
       values, see <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-getclusternetworkstate">GetClusterNetworkState</a>.


### -field CLUSTER_CHANGE_NETWORK_DELETED

The queue receives a notification when a network is permanently removed from the cluster environment.


### -field CLUSTER_CHANGE_NETWORK_ADDED

The queue receives a notification when a new 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/networks">network</a> is added to the cluster environment.


### -field CLUSTER_CHANGE_NETWORK_PROPERTY

The queue receives a notification when the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/network-common-properties">properties</a> of an existing network change.


### -field CLUSTER_CHANGE_NETINTERFACE_STATE

The queue receives a notification when a network interface changes state. For a list of the possible network 
       interface state values, see 
       <a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-getclusternetinterfacestate">GetClusterNetInterfaceState</a>.


### -field CLUSTER_CHANGE_NETINTERFACE_DELETED

The queue receives a notification when a network interface is permanently removed from a cluster node.


### -field CLUSTER_CHANGE_NETINTERFACE_ADDED

The queue receives a notification when a new 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/network-interfaces">network interface</a> is added to a cluster 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/nodes">node</a>.


### -field CLUSTER_CHANGE_NETINTERFACE_PROPERTY

The queue receives a notification when the 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/network-interface-common-properties">properties</a> of an existing network 
       interface change.


### -field CLUSTER_CHANGE_QUORUM_STATE

This notification is reserved for future use.


### -field CLUSTER_CHANGE_CLUSTER_STATE

The queue receives a notification when the cluster becomes unavailable, meaning that all attempts to 
       communicate with the cluster fail.


### -field CLUSTER_CHANGE_CLUSTER_PROPERTY

The queue receives a notification when the cluster's prioritized list of internal 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/networks">networks</a> changes.


### -field CLUSTER_CHANGE_HANDLE_CLOSE

The queue receives a notification when a handle associated with a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-objects">cluster object</a> is closed.


### -field CLUSTER_CHANGE_ALL


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/nf-clusapi-clusterregsetkeysecurity">ClusterRegSetKeySecurity</a>



<a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-createcluster">CreateCluster</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-getclusternotify">GetClusterNotify</a>



<a href="https://docs.microsoft.com/windows/desktop/api/clusapi/nf-clusapi-registerclusternotify">RegisterClusterNotify</a>
 

 

