---
UID: NE:msclus.CLUSTER_PROPERTY_SYNTAX
title: CLUSTER_PROPERTY_SYNTAX (msclus.h)
description: Provides the possible values for the syntax structures in a property list.
old-location: mscs\cluster_property_syntax.htm
tech.root: MsCS
ms.assetid: caadeb63-297c-4657-8ee2-975fceff5484
ms.date: 12/05/2018
ms.keywords: CLUSPROP_SYNTAX_DISK_GUID, CLUSPROP_SYNTAX_DISK_NUMBER, CLUSPROP_SYNTAX_DISK_SERIALNUMBER, CLUSPROP_SYNTAX_DISK_SIGNATURE, CLUSPROP_SYNTAX_DISK_SIZE, CLUSPROP_SYNTAX_ENDMARK, CLUSPROP_SYNTAX_FTSET_INFO, CLUSPROP_SYNTAX_LIST_VALUE_BINARY, CLUSPROP_SYNTAX_LIST_VALUE_DWORD, CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ, CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ, CLUSPROP_SYNTAX_LIST_VALUE_FILETIME, CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER, CLUSPROP_SYNTAX_LIST_VALUE_LONG, CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ, CLUSPROP_SYNTAX_LIST_VALUE_PROPERTY_LIST, CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR, CLUSPROP_SYNTAX_LIST_VALUE_SZ, CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER, CLUSPROP_SYNTAX_LIST_VALUE_WORD, CLUSPROP_SYNTAX_NAME, CLUSPROP_SYNTAX_PARTITION_INFO, CLUSPROP_SYNTAX_PARTITION_INFO_EX, CLUSPROP_SYNTAX_PARTITION_INFO_EX2, CLUSPROP_SYNTAX_RESCLASS, CLUSPROP_SYNTAX_SCSI_ADDRESS, CLUSPROP_SYNTAX_STORAGE_DEVICE_ID_DESCRIPTOR, CLUSTER_PROPERTY_SYNTAX, CLUSTER_PROPERTY_SYNTAX enumeration [Failover Cluster], _CLUSTER_PROPERTY_SYNTAX, _CLUSTER_PROPERTY_SYNTAX enumeration [Failover Cluster], clusapi/CLUSPROP_SYNTAX_DISK_GUID, clusapi/CLUSPROP_SYNTAX_DISK_NUMBER, clusapi/CLUSPROP_SYNTAX_DISK_SERIALNUMBER, clusapi/CLUSPROP_SYNTAX_DISK_SIGNATURE, clusapi/CLUSPROP_SYNTAX_DISK_SIZE, clusapi/CLUSPROP_SYNTAX_ENDMARK, clusapi/CLUSPROP_SYNTAX_FTSET_INFO, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_BINARY, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_DWORD, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_FILETIME, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_LONG, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_PROPERTY_LIST, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_SZ, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER, clusapi/CLUSPROP_SYNTAX_LIST_VALUE_WORD, clusapi/CLUSPROP_SYNTAX_NAME, clusapi/CLUSPROP_SYNTAX_PARTITION_INFO, clusapi/CLUSPROP_SYNTAX_PARTITION_INFO_EX, clusapi/CLUSPROP_SYNTAX_PARTITION_INFO_EX2, clusapi/CLUSPROP_SYNTAX_RESCLASS, clusapi/CLUSPROP_SYNTAX_SCSI_ADDRESS, clusapi/CLUSPROP_SYNTAX_STORAGE_DEVICE_ID_DESCRIPTOR, clusapi/CLUSTER_PROPERTY_SYNTAX, clusapi/_CLUSTER_PROPERTY_SYNTAX, msclus/CLUSPROP_SYNTAX_DISK_GUID, msclus/CLUSPROP_SYNTAX_DISK_NUMBER, msclus/CLUSPROP_SYNTAX_DISK_SERIALNUMBER, msclus/CLUSPROP_SYNTAX_DISK_SIGNATURE, msclus/CLUSPROP_SYNTAX_DISK_SIZE, msclus/CLUSPROP_SYNTAX_ENDMARK, msclus/CLUSPROP_SYNTAX_FTSET_INFO, msclus/CLUSPROP_SYNTAX_LIST_VALUE_BINARY, msclus/CLUSPROP_SYNTAX_LIST_VALUE_DWORD, msclus/CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ, msclus/CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ, msclus/CLUSPROP_SYNTAX_LIST_VALUE_FILETIME, msclus/CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER, msclus/CLUSPROP_SYNTAX_LIST_VALUE_LONG, msclus/CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ, msclus/CLUSPROP_SYNTAX_LIST_VALUE_PROPERTY_LIST, msclus/CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR, msclus/CLUSPROP_SYNTAX_LIST_VALUE_SZ, msclus/CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER, msclus/CLUSPROP_SYNTAX_LIST_VALUE_WORD, msclus/CLUSPROP_SYNTAX_NAME, msclus/CLUSPROP_SYNTAX_PARTITION_INFO, msclus/CLUSPROP_SYNTAX_PARTITION_INFO_EX, msclus/CLUSPROP_SYNTAX_PARTITION_INFO_EX2, msclus/CLUSPROP_SYNTAX_RESCLASS, msclus/CLUSPROP_SYNTAX_SCSI_ADDRESS, msclus/CLUSPROP_SYNTAX_STORAGE_DEVICE_ID_DESCRIPTOR, msclus/CLUSTER_PROPERTY_SYNTAX, msclus/_CLUSTER_PROPERTY_SYNTAX, mscs.cluster_property_syntax
f1_keywords:
- msclus/CLUSTER_PROPERTY_SYNTAX
dev_langs:
- c++
req.header: msclus.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Enterprise, Windows Server 2008 Datacenter
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUSTER_PROPERTY_SYNTAX
targetos: Windows
req.typenames: CLUSTER_PROPERTY_SYNTAX
req.redist: 
ms.custom: 19H1
---

# CLUSTER_PROPERTY_SYNTAX enumeration


## -description


Provides the possible values for the syntax structures in a 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/property-lists">property list</a>.


## -enum-fields




### -field CLUSPROP_SYNTAX_ENDMARK

Marks the end of a value list.


### -field CLUSPROP_SYNTAX_NAME

Describes a property name, such as the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/resources-name">Name</a> 
       property for resources and the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/nodes-nodename">NodeName</a> property for 
       nodes. A property name is represented by a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa368382(v=vs.85)">CLUSPROP_PROPERTY_NAME</a> structure.


### -field CLUSPROP_SYNTAX_RESCLASS

Describes a resource class value. A resource class value is represented by a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_resource_class">CLUSPROP_RESOURCE_CLASS</a> structure.


### -field CLUSPROP_SYNTAX_LIST_VALUE_SZ

Describes a null-terminated Unicode string value in a property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ

Describes a null-terminated Unicode string value with unexpanded references to environment variables in a 
       property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_DWORD

Describes a <b>DWORD</b> value in a property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_BINARY

Describes a binary value in a property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_MULTI_SZ

Describes an array of null-terminated Unicode string values in a property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_LONG

Describes a signed <b>long</b> value in a property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ

Describes a null-terminated Unicode string value with expanded references to environment variables in a 
       property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_SECURITY_DESCRIPTOR

Describes a <a href="https://docs.microsoft.com/windows/desktop/api/winnt/ns-winnt-security_descriptor">SECURITY_DESCRIPTOR</a> in 
       <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">self-relative</a> format 
       in a property list. For more information about self-relative security descriptors, see 
       <a href="https://docs.microsoft.com/windows/desktop/SecAuthZ/absolute-and-self-relative-security-descriptors">Absolute and Self-Relative Security Descriptors</a>.


### -field CLUSPROP_SYNTAX_LIST_VALUE_LARGE_INTEGER

Describes a signed large integer value in a property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_ULARGE_INTEGER

Describes an unsigned large integer value in a property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_WORD

Describes a <b>WORD</b> value in a property list.


### -field CLUSPROP_SYNTAX_LIST_VALUE_PROPERTY_LIST

Describes a property list.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported until Windows Server 2016.


### -field CLUSPROP_SYNTAX_LIST_VALUE_FILETIME

Describes a <a href="https://docs.microsoft.com/windows/desktop/api/minwinbase/ns-minwinbase-filetime">FILETIME</a> value in a property list.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported until Windows Server 2016.


### -field CLUSPROP_SYNTAX_DISK_SIGNATURE

Describes a master boot record (MBR) disk signature value represented by a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa368374(v=vs.85)">CLUSPROP_DISK_SIGNATURE</a> structure.


### -field CLUSPROP_SYNTAX_SCSI_ADDRESS

Describes the address for an <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/ip-address">IP Address</a> resource. IP 
       Address resources store this address in their 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/ip-addresses-address">Address</a> private property. A SCSI address value 
       is represented by a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_scsi_address">CLUSPROP_SCSI_ADDRESS</a> 
       structure.


### -field CLUSPROP_SYNTAX_DISK_NUMBER

Describes a disk number value represented by a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_dword">CLUSPROP_DISK_NUMBER</a> structure.


### -field CLUSPROP_SYNTAX_PARTITION_INFO

Describes a collection of information about a Physical Disk resource, such as its device name and volume 
       label. Partition information is represented by a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_partition_info">CLUSPROP_PARTITION_INFO</a> structure.


### -field CLUSPROP_SYNTAX_FTSET_INFO

Describes <a href="https://docs.microsoft.com/windows/desktop/api/minwinbase/ns-minwinbase-filetime">FILETIME</a> set information.


### -field CLUSPROP_SYNTAX_DISK_SERIALNUMBER

Describes a null-terminated Unicode string value containing  a serial number of a disk resource.


### -field CLUSPROP_SYNTAX_DISK_GUID

Describes a null-terminated Unicode string value containing  the <b>GUID</b> of a 
       <b>GUID</b> partitioning table (GPT) disk resource.


### -field CLUSPROP_SYNTAX_DISK_SIZE

Describes a unsigned large integer value containing the total size of a disk in bytes.


### -field CLUSPROP_SYNTAX_PARTITION_INFO_EX

Describes a collection of information about a Physical Disk resource, such as its device name and volume 
       label. Partition information is represented by a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_partition_info_ex">CLUSPROP_PARTITION_INFO_EX</a> structure.


### -field CLUSPROP_SYNTAX_PARTITION_INFO_EX2

Describes a collection of information about a Physical Disk resource, such as its device name and volume 
       label. The partition information is represented by a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_partition_info_ex2">CLUSPROP_PARTITION_INFO_EX2</a> structure.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This value is not available until Windows Server 2016 .


### -field CLUSPROP_SYNTAX_STORAGE_DEVICE_ID_DESCRIPTOR

Describes descriptor data for a storage class resource.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This value is not available until Windows Server 2016 .


## -remarks



The upper 2 bytes of a <b>CLUSTER_PROPERTY_SYNTAX</b> 
     must be a valid <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ne-clusapi-cluster_property_type">CLUSTER_PROPERTY_TYPE</a>. The lower 2 
     bytes of a <b>CLUSTER_PROPERTY_SYNTAX</b> must be a 
     valid <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ne-clusapi-cluster_property_format">CLUSTER_PROPERTY_FORMAT</a>.

The client must not specify a syntax value of 
     <b>CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ</b> when adding a property value to a 
     <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/property-lists">property list</a> structure. When constructing a 
     property list structure to return to the client, the server 
     must return two values for a property's value that is of syntax 
     <b>CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ</b>: the first value is of syntax 
     <b>CLUSPROP_SYNTAX_LIST_VALUE_EXPAND_SZ</b>, containing the property value, as it is stored 
     on the server, and the second is of syntax <b>CLUSPROP_SYNTAX_LIST_VALUE_EXPANDED_SZ</b> 
     which is the same property value where each embedded environment variable has been replaced by its value, as 
     stored on the server.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_syntax">CLUSPROP_SYNTAX</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ne-clusapi-cluster_property_format">CLUSTER_PROPERTY_FORMAT</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ne-clusapi-cluster_property_type">CLUSTER_PROPERTY_TYPE</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>
 

 

