---
UID: NE:msclus.CLUSTER_PROPERTY_TYPE
title: CLUSTER_PROPERTY_TYPE (msclus.h)
description: Defines the property types that are supported by a cluster property list.
old-location: mscs\cluster_property_type.htm
tech.root: MsCS
ms.assetid: 4a10d4f1-2a50-42e7-a143-e9a93d9fcc42
ms.date: 12/05/2018
ms.keywords: CLUSPROP_TYPE_CSV_PARTITION_INFO_EX, CLUSPROP_TYPE_DISKID, CLUSPROP_TYPE_DISK_GUID, CLUSPROP_TYPE_DISK_HEADER_IDS, CLUSPROP_TYPE_DISK_NUMBER, CLUSPROP_TYPE_DISK_PRIV_PROPERTIES, CLUSPROP_TYPE_DISK_SERIALNUMBER, CLUSPROP_TYPE_DISK_SIZE, CLUSPROP_TYPE_DISK_SP_ID, CLUSPROP_TYPE_DISK_VALUES, CLUSPROP_TYPE_ENDMARK, CLUSPROP_TYPE_FTSET_INFO, CLUSPROP_TYPE_LIST_VALUE, CLUSPROP_TYPE_NAME, CLUSPROP_TYPE_NODE_BITMASK, CLUSPROP_TYPE_NODE_INDEX, CLUSPROP_TYPE_NODE_NAME, CLUSPROP_TYPE_PARTITION_INFO, CLUSPROP_TYPE_PARTITION_INFO_EX, CLUSPROP_TYPE_PARTITION_INFO_EX2, CLUSPROP_TYPE_POOL_INFO, CLUSPROP_TYPE_POOL_PRIV_PROPERTIES, CLUSPROP_TYPE_RESCLASS, CLUSPROP_TYPE_RESERVED1, CLUSPROP_TYPE_RESOURCE_ID, CLUSPROP_TYPE_SCSI_ADDRESS, CLUSPROP_TYPE_SIGNATURE, CLUSPROP_TYPE_STORAGE_DEVICE_ID_DESCRIPTOR, CLUSPROP_TYPE_UNKNOWN, CLUSPROP_TYPE_USER, CLUSPROP_TYPE_VOLUME_INFO, CLUSTER_PROPERTY_TYPE, CLUSTER_PROPERTY_TYPE enumeration [Failover Cluster], _CLUSTER_PROPERTY_TYPE, _CLUSTER_PROPERTY_TYPE enumeration [Failover Cluster], clusapi/CLUSPROP_TYPE_CSV_PARTITION_INFO_EX, clusapi/CLUSPROP_TYPE_DISKID, clusapi/CLUSPROP_TYPE_DISK_GUID, clusapi/CLUSPROP_TYPE_DISK_HEADER_IDS, clusapi/CLUSPROP_TYPE_DISK_NUMBER, clusapi/CLUSPROP_TYPE_DISK_PRIV_PROPERTIES, clusapi/CLUSPROP_TYPE_DISK_SERIALNUMBER, clusapi/CLUSPROP_TYPE_DISK_SIZE, clusapi/CLUSPROP_TYPE_DISK_SP_ID, clusapi/CLUSPROP_TYPE_DISK_VALUES, clusapi/CLUSPROP_TYPE_ENDMARK, clusapi/CLUSPROP_TYPE_FTSET_INFO, clusapi/CLUSPROP_TYPE_LIST_VALUE, clusapi/CLUSPROP_TYPE_NAME, clusapi/CLUSPROP_TYPE_NODE_BITMASK, clusapi/CLUSPROP_TYPE_NODE_INDEX, clusapi/CLUSPROP_TYPE_NODE_NAME, clusapi/CLUSPROP_TYPE_PARTITION_INFO, clusapi/CLUSPROP_TYPE_PARTITION_INFO_EX, clusapi/CLUSPROP_TYPE_PARTITION_INFO_EX2, clusapi/CLUSPROP_TYPE_POOL_INFO, clusapi/CLUSPROP_TYPE_POOL_PRIV_PROPERTIES, clusapi/CLUSPROP_TYPE_RESCLASS, clusapi/CLUSPROP_TYPE_RESERVED1, clusapi/CLUSPROP_TYPE_RESOURCE_ID, clusapi/CLUSPROP_TYPE_SCSI_ADDRESS, clusapi/CLUSPROP_TYPE_SIGNATURE, clusapi/CLUSPROP_TYPE_STORAGE_DEVICE_ID_DESCRIPTOR, clusapi/CLUSPROP_TYPE_UNKNOWN, clusapi/CLUSPROP_TYPE_USER, clusapi/CLUSPROP_TYPE_VOLUME_INFO, clusapi/CLUSTER_PROPERTY_TYPE, clusapi/_CLUSTER_PROPERTY_TYPE, msclus/CLUSPROP_TYPE_CSV_PARTITION_INFO_EX, msclus/CLUSPROP_TYPE_DISKID, msclus/CLUSPROP_TYPE_DISK_GUID, msclus/CLUSPROP_TYPE_DISK_HEADER_IDS, msclus/CLUSPROP_TYPE_DISK_NUMBER, msclus/CLUSPROP_TYPE_DISK_PRIV_PROPERTIES, msclus/CLUSPROP_TYPE_DISK_SERIALNUMBER, msclus/CLUSPROP_TYPE_DISK_SIZE, msclus/CLUSPROP_TYPE_DISK_SP_ID, msclus/CLUSPROP_TYPE_DISK_VALUES, msclus/CLUSPROP_TYPE_ENDMARK, msclus/CLUSPROP_TYPE_FTSET_INFO, msclus/CLUSPROP_TYPE_LIST_VALUE, msclus/CLUSPROP_TYPE_NAME, msclus/CLUSPROP_TYPE_NODE_BITMASK, msclus/CLUSPROP_TYPE_NODE_INDEX, msclus/CLUSPROP_TYPE_NODE_NAME, msclus/CLUSPROP_TYPE_PARTITION_INFO, msclus/CLUSPROP_TYPE_PARTITION_INFO_EX, msclus/CLUSPROP_TYPE_PARTITION_INFO_EX2, msclus/CLUSPROP_TYPE_POOL_INFO, msclus/CLUSPROP_TYPE_POOL_PRIV_PROPERTIES, msclus/CLUSPROP_TYPE_RESCLASS, msclus/CLUSPROP_TYPE_RESERVED1, msclus/CLUSPROP_TYPE_RESOURCE_ID, msclus/CLUSPROP_TYPE_SCSI_ADDRESS, msclus/CLUSPROP_TYPE_SIGNATURE, msclus/CLUSPROP_TYPE_STORAGE_DEVICE_ID_DESCRIPTOR, msclus/CLUSPROP_TYPE_UNKNOWN, msclus/CLUSPROP_TYPE_USER, msclus/CLUSPROP_TYPE_VOLUME_INFO, msclus/CLUSTER_PROPERTY_TYPE, msclus/_CLUSTER_PROPERTY_TYPE, mscs.cluster_property_type
f1_keywords:
- msclus/CLUSTER_PROPERTY_TYPE
dev_langs:
- c++
req.header: msclus.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 Enterprise, Windows Server 2008 Datacenter
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ClusAPI.h
- MsClus.h
api_name:
- CLUSTER_PROPERTY_TYPE
targetos: Windows
req.typenames: CLUSTER_PROPERTY_TYPE
req.redist: 
ms.custom: 19H1
---

# CLUSTER_PROPERTY_TYPE enumeration


## -description


This enumeration defines the property types that are supported by a cluster <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/property-lists">property list</a>.


## -enum-fields




### -field CLUSPROP_TYPE_UNKNOWN

The property type is unknown.


### -field CLUSPROP_TYPE_ENDMARK

Designates the data value as the last entry in a property or value list.


### -field CLUSPROP_TYPE_LIST_VALUE

Describes a data value in a property list. For example, in the property list passed to a 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/control-code-functions">control code function</a> for a property validation 
      operation, <b>CLUSPROP_TYPE_LIST_VALUE</b> is the required type to be included with each 
      property value.


### -field CLUSPROP_TYPE_RESCLASS

Describes resource class information. A resource class value is described with a 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_resource_class">CLUSPROP_RESOURCE_CLASS</a> 
       structure. Resource classes are returned when an application calls 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/nf-clusapi-clusterresourcecontrol">ClusterResourceControl</a> or 
       <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/nf-clusapi-clusterresourcetypecontrol">ClusterResourceTypeControl</a> with one of 
       the following control codes:


<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-get-class-info">CLUSCTL_RESOURCE_GET_CLASS_INFO</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-class-info">CLUSCTL_RESOURCE_TYPE_GET_CLASS_INFO</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/clusctl-resource-type-get-required-dependencies">CLUSCTL_RESOURCE_TYPE_GET_REQUIRED_DEPENDENCIES</a>



### -field CLUSPROP_TYPE_RESERVED1

Reserved for future use.


### -field CLUSPROP_TYPE_NAME

Describes a data value used as a name, such as a property name. A name value is represented by a 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa368382(v=vs.85)">CLUSPROP_PROPERTY_NAME</a> 
      structure.


### -field CLUSPROP_TYPE_SIGNATURE

Describes a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/physical-disks-signature">Signature</a> property for 
      a disk resource. A signature value is represented by a 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/legacy/aa368374(v=vs.85)">CLUSPROP_DISK_SIGNATURE</a> structure.


### -field CLUSPROP_TYPE_SCSI_ADDRESS

Describes an <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/ip-addresses-address">Address</a> 
      property for an <a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/ip-address">IP Address</a> resource. A SCSI 
      address value is represented by a 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_scsi_address">CLUSPROP_SCSI_ADDRESS</a> 
      structure.


### -field CLUSPROP_TYPE_DISK_NUMBER

Describes the number value of a disk resource. A disk number value is represented by a 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_dword">CLUSPROP_DISK_NUMBER</a> 
      structure.


### -field CLUSPROP_TYPE_PARTITION_INFO

Describes a collection of information about a disk resource, such as its device name and volume label. 
      Partition data is represented by a 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_partition_info">CLUSPROP_PARTITION_INFO</a> 
      structure.


### -field CLUSPROP_TYPE_FTSET_INFO

Describes <a href="https://docs.microsoft.com/windows/desktop/api/minwinbase/ns-minwinbase-filetime">FILETIME</a> set information.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported.


### -field CLUSPROP_TYPE_DISK_SERIALNUMBER

Describes the serial number of a disk resource.


### -field CLUSPROP_TYPE_DISK_GUID

Describes the <b>GUID</b> of a disk resource.


### -field CLUSPROP_TYPE_DISK_SIZE

Describes the total size of a disk in bytes.


### -field CLUSPROP_TYPE_PARTITION_INFO_EX

Describes a collection of information about a disk resource, such as its device name and volume label. 
      Partition data is represented by a 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_partition_info_ex">CLUSPROP_PARTITION_INFO_EX</a> 
      structure.


### -field CLUSPROP_TYPE_PARTITION_INFO_EX2

Describes a collection of information about a disk resource, such as its device name and volume label. 
      Partition data is represented by a 
      <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_partition_info_ex2">CLUSPROP_PARTITION_INFO_EX2</a>  
      structure.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This value is not available until Windows Server 2016 .


### -field CLUSPROP_TYPE_STORAGE_DEVICE_ID_DESCRIPTOR

Describes descriptor data for a storage class resource.

<b>Windows Server 2012 R2, Windows Server 2012, Windows Server 2008 R2 and Windows Server 2008:  </b>This value is not available until Windows Server 2016 .


### -field CLUSPROP_TYPE_USER

Describes the beginning of the range for users to define their own types. Associate this type with 
      user-defined private properties.


#### - CLUSPROP_TYPE_CSV_PARTITION_INFO_EX

Describes partition information for a cluster shared volume (CSV).

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_DISKID

Describes the identifier of a disk resource.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_DISK_HEADER_IDS

Describes the header identifiers of a disk resource.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_DISK_PRIV_PROPERTIES

Describes the private properties of a disk resource.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_DISK_SP_ID

Describes the storage pool identifier of a disk resource.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_DISK_VALUES

Describes the values of a disk resource.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_NODE_BITMASK

Describes a bitmask for a node.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_NODE_INDEX

Describes a node index.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_NODE_NAME

Describes the name of a node.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_POOL_INFO

Describes storage pool information.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_POOL_PRIV_PROPERTIES

Describes the private properties of a storage pool.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_RESOURCE_ID

Describes the identifier of a resource.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


#### - CLUSPROP_TYPE_VOLUME_INFO

Describes volume information.

<b>Windows Server 2008 R2 and Windows Server 2008:  </b>This enumeration value is not supported in any version of Windows Server, and was removed in Windows Server 2012 R2.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/clusapi/ns-clusapi-clusprop_syntax">CLUSPROP_SYNTAX</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluster-enumerations">Failover Cluster Enumerations</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/mscs/cluspropertyvalue-type">Type Property of the ClusPropertyValue Object</a>
 

 

