---
UID: NE:msctf.__MIDL___MIDL_itf_msctf_0000_0070_0001
title: TF_DA_LINESTYLE (msctf.h)
description: Elements of the TF_DA_LINESTYLE enumeration specify the underline style of a display attribute in the TF_DA_COLOR structure.
old-location: tsf\tf_da_linestyle.htm
tech.root: TSF
ms.assetid: 36ea6359-e25a-4b23-8d9d-961d743268ab
ms.date: 12/05/2018
ms.keywords: TF_DA_LINESTYLE, TF_DA_LINESTYLE enumeration [Text Services Framework], TF_LS_DASH, TF_LS_DOT, TF_LS_NONE, TF_LS_SOLID, TF_LS_SQUIGGLE, _tsf_tf_da_linestyle_ref, msctf/TF_DA_LINESTYLE, msctf/TF_LS_DASH, msctf/TF_LS_DOT, msctf/TF_LS_NONE, msctf/TF_LS_SOLID, msctf/TF_LS_SQUIGGLE, tsf.tf_da_linestyle
f1_keywords:
- msctf/TF_DA_LINESTYLE
dev_langs:
- c++
req.header: msctf.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Msctf.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Msctf.h
api_name:
- TF_DA_LINESTYLE
targetos: Windows
req.typenames: TF_DA_LINESTYLE
req.redist: TSF 1.0 on Windows 2000 Professional
ms.custom: 19H1
---

# TF_DA_LINESTYLE enumeration


## -description


Elements of the <b>TF_DA_LINESTYLE</b> enumeration specify the underline style of a display attribute in the <a href="https://docs.microsoft.com/windows/desktop/api/msctf/ns-msctf-tf_da_color">TF_DA_COLOR</a> structure.


## -enum-fields




### -field TF_LS_NONE

The text is not underlined.


### -field TF_LS_SOLID

The text is underlined with a solid line.


### -field TF_LS_DOT

The text is underlined with a dotted line.


### -field TF_LS_DASH

The text is underlined with a dashed line.


### -field TF_LS_SQUIGGLE

The text is underlined with a solid wavy line.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/msctf/ns-msctf-tf_da_color">TF_DA_COLOR
      </a>
 

 

