---
UID: NE:msdrmdefs._DRMSECURITYPROVIDERTYPE
title: DRMSECURITYPROVIDERTYPE (msdrmdefs.h)
description: The DRMSECURITYPROVIDERTYPE enumeration specifies the type of secure DRM environment used.
old-location: rm\drmsecurityprovidertype.htm
tech.root: AdRms_Sdk
ms.assetid: e8b81e48-d13a-4b7d-b7a4-a197dc81dc6b
ms.date: 12/05/2018
ms.keywords: DRMSECURITYPROVIDERTYPE, DRMSECURITYPROVIDERTYPE enumeration [Active Directory Rights Management Services SDK 1.0], DRMSECURITYPROVIDERTYPE_SOFTWARESECREP, msdrmdefs/DRMSECURITYPROVIDERTYPE, msdrmdefs/DRMSECURITYPROVIDERTYPE_SOFTWARESECREP, rm.drmsecurityprovidertype
f1_keywords:
- msdrmdefs/DRMSECURITYPROVIDERTYPE
dev_langs:
- c++
req.header: msdrmdefs.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Msdrmdefs.h
api_name:
- DRMSECURITYPROVIDERTYPE
targetos: Windows
req.typenames: DRMSECURITYPROVIDERTYPE
req.redist: 
req.product: Rights Management Services client 1.0 SP2 or later
ms.custom: 19H1
---

# DRMSECURITYPROVIDERTYPE enumeration


## -description


<p class="CCE_Message">[The AD RMS SDK leveraging functionality exposed by 

the client in Msdrm.dll is available for use in Windows Server 2008, Windows Vista, Windows Server 2008 R2, Windows 7, Windows Server 2012, and Windows 8. It may be altered or 

unavailable in subsequent versions. Instead, use <a href="https://docs.microsoft.com/previous-versions/windows/desktop/msipc/microsoft-information-protection-and-control-client-portal">Active Directory Rights Management Services SDK 2.1</a>, 

which leverages functionality exposed by the client in Msipc.dll.]

The <b>DRMSECURITYPROVIDERTYPE</b> enumeration specifies the type of secure DRM environment used.


## -enum-fields




### -field DRMSECURITYPROVIDERTYPE_SOFTWARESECREP

Software-level security, using a lockbox.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/adrms_sdk/ad-rms-enumerations">AD RMS Enumerations</a>
 

 

