---
UID: NF:msi.MsiAdvertiseScriptA
title: MsiAdvertiseScriptA function (msi.h)
description: The MsiAdvertiseScript function copies an advertised script file into the specified locations.
old-location: setup\msiadvertisescript.htm
tech.root: Msi
ms.assetid: 2c255c01-554b-42da-82ff-c946a40098ed
ms.date: 12/05/2018
ms.keywords: MsiAdvertiseScript, MsiAdvertiseScript function, MsiAdvertiseScriptA, MsiAdvertiseScriptW, SCRIPTFLAGS_CACHEINFO, SCRIPTFLAGS_MACHINEASSIGN, SCRIPTFLAGS_REGDATA, SCRIPTFLAGS_REGDATA_APPINFO, SCRIPTFLAGS_REGDATA_CLASSINFO, SCRIPTFLAGS_REGDATA_CNFGINFO, SCRIPTFLAGS_REGDATA_EXTENSIONINFO, SCRIPTFLAGS_SHORTCUTS, SCRIPTFLAGS_VALIDATE_TRANSFORMS_LIST, _msi_msiadvertisescript, msi/MsiAdvertiseScript, msi/MsiAdvertiseScriptA, msi/MsiAdvertiseScriptW, setup.msiadvertisescript
f1_keywords:
- msi/MsiAdvertiseScript
dev_langs:
- c++
req.header: msi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Installer 5.0 on Windows Server 2012, Windows 8, Windows Server 2008 R2 or Windows 7. Windows Installer 4.0 or Windows Installer 4.5 on   Windows Server 2008 or Windows Vista. Windows Installer on Windows Server 2003 or Windows XP. See the Windows Installer Run-Time Requirements for information about the minimum Windows service pack that is required by a Windows Installer version.
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: MsiAdvertiseScriptW (Unicode) and MsiAdvertiseScriptA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Msi.lib
req.dll: Msi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Msi.dll
api_name:
- MsiAdvertiseScript
- MsiAdvertiseScriptA
- MsiAdvertiseScriptW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# MsiAdvertiseScriptA function


## -description


The 
<b>MsiAdvertiseScript</b> function copies an advertised script file into the specified locations.


## -parameters




### -param szScriptFile [in]

The full path to a script file generated by 
<a href="https://docs.microsoft.com/windows/desktop/api/msi/nf-msi-msiadvertiseproducta">MsiAdvertiseProduct</a> or 
<a href="https://docs.microsoft.com/windows/desktop/api/msi/nf-msi-msiadvertiseproductexa">MsiAdvertiseProductEx</a>.


### -param dwFlags [in]

The following bit flags from SCRIPTFLAGS control advertisement. The value of <i>dwFlags</i> can be a combination of the following values. 



<table>
<tr>
<th>Flag</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_CACHEINFO"></a><a id="scriptflags_cacheinfo"></a><dl>
<dt><b>SCRIPTFLAGS_CACHEINFO</b></dt>
<dt>0x001</dt>
</dl>
</td>
<td width="60%">
Include this flag if the icons need to be created or removed.

</td>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_SHORTCUTS"></a><a id="scriptflags_shortcuts"></a><dl>
<dt><b>SCRIPTFLAGS_SHORTCUTS</b></dt>
<dt>0x004</dt>
</dl>
</td>
<td width="60%">
Include this flag if the shortcuts need to be created or removed.

</td>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_MACHINEASSIGN"></a><a id="scriptflags_machineassign"></a><dl>
<dt><b>SCRIPTFLAGS_MACHINEASSIGN</b></dt>
<dt>0x008</dt>
</dl>
</td>
<td width="60%">
Include this flag if the product to be assigned to a computer.

</td>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_REGDATA_CNFGINFO"></a><a id="scriptflags_regdata_cnfginfo"></a><dl>
<dt><b>SCRIPTFLAGS_REGDATA_CNFGINFO</b></dt>
<dt>0x020</dt>
</dl>
</td>
<td width="60%">
Include this flag if the configuration and management information in the registry data needs to be written or removed.

</td>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_VALIDATE_TRANSFORMS_LIST"></a><a id="scriptflags_validate_transforms_list"></a><dl>
<dt><b>SCRIPTFLAGS_VALIDATE_TRANSFORMS_LIST</b></dt>
<dt>0x040</dt>
</dl>
</td>
<td width="60%">
Include this flag to force validation of the transforms listed in the script against previously registered transforms for this product. Note that transform conflicts are detected using a string comparison that is case insensitive and are evaluated between per-user and per-machine installations across all contexts. If the list of transforms in the script does not match the transforms registered for the product, the function returns ERROR_INSTALL_TRANSFORM_FAILURE.

</td>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_REGDATA_CLASSINFO"></a><a id="scriptflags_regdata_classinfo"></a><dl>
<dt><b>SCRIPTFLAGS_REGDATA_CLASSINFO</b></dt>
<dt>0x080</dt>
</dl>
</td>
<td width="60%">
Include this flag if advertisement information in the registry related to COM classes needs to be written or removed.

</td>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_REGDATA_EXTENSIONINFO"></a><a id="scriptflags_regdata_extensioninfo"></a><dl>
<dt><b>SCRIPTFLAGS_REGDATA_EXTENSIONINFO</b></dt>
<dt>0x100</dt>
</dl>
</td>
<td width="60%">
Include this flag if advertisement information in the registry related to an extension needs to be written or removed.

</td>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_REGDATA_APPINFO"></a><a id="scriptflags_regdata_appinfo"></a><dl>
<dt><b>SCRIPTFLAGS_REGDATA_APPINFO</b></dt>
<dt>0x180</dt>
</dl>
</td>
<td width="60%">
Include this flag if the advertisement information in the registry needs to be written or removed. 

</td>
</tr>
<tr>
<td width="40%"><a id="SCRIPTFLAGS_REGDATA"></a><a id="scriptflags_regdata"></a><dl>
<dt><b>SCRIPTFLAGS_REGDATA</b></dt>
<dt>0x1A0</dt>
</dl>
</td>
<td width="60%">
Include this flag if the advertisement information in the registry needs to be written or removed.

</td>
</tr>
</table>
 


### -param phRegData [in]

A registry key under which temporary information about registry data is to be written. If this parameter is null, the registry data is placed under the appropriate key, based on whether the advertisement is per-user or per-machine. If this parameter is non-null, the script will write the registry data under the specified registry key rather than the normal location. In this case, the application will not get advertised to the user. 




Note that this registry key cannot be used when generating an advertisement of a product for a user or a computer because the provider of the registry key generally deletes the key. The registry key is located outside of the normal registry locations for shell, class, and .msi configuration information and it is not under <b>HKEY_CLASSES_ROOT</b>. This registry key is only intended for getting temporary information about registry data in a script.


### -param fRemoveItems [in]

TRUE if specified items are to be removed instead of being created.


## -returns



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_SUCCESS</b></dt>
</dl>
</td>
<td width="60%">
The function completed successfully.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_ACCESS_DENIED</b></dt>
</dl>
</td>
<td width="60%">
The calling process was not running under the LocalSystem account.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>An error relating to an action</b></dt>
</dl>
</td>
<td width="60%">
See 
<a href="https://docs.microsoft.com/windows/desktop/Msi/error-codes">Error Codes</a>.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="https://docs.microsoft.com/windows/desktop/Msi/initialization-errors">Initialization Error</a></b></dt>
</dl>
</td>
<td width="60%">
An error relating to initialization occurred.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_CALL_NOT_IMPLEMENTED</b></dt>
</dl>
</td>
<td width="60%">
This function  is only available on Windows 2000 and Windows XP.

</td>
</tr>
</table>
 


<div> </div>





## -remarks



The process calling this function must be running under the LocalSystem account. To advertise an application for per-user installation to a targeted user, the thread that calls this function must impersonate the targeted user. If the thread calling this function is not impersonating a targeted user, the application is advertised to all users for installation with elevated privileges.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/Msi/installation-context">Installation Context</a>
 

 

