---
UID: NF:msi.MsiProcessAdvertiseScriptW
title: MsiProcessAdvertiseScriptW function (msi.h)
description: The MsiProcessAdvertiseScript function processes an advertise script file into the specified locations.
old-location: setup\msiprocessadvertisescript.htm
tech.root: Msi
ms.assetid: 2c418552-2c06-4797-9fa3-d36e69ef0d53
ms.date: 12/05/2018
ms.keywords: MsiProcessAdvertiseScript, MsiProcessAdvertiseScript function, MsiProcessAdvertiseScriptA, MsiProcessAdvertiseScriptW, _msi_msiprocessadvertisescript, msi/MsiProcessAdvertiseScript, msi/MsiProcessAdvertiseScriptA, msi/MsiProcessAdvertiseScriptW, setup.msiprocessadvertisescript
f1_keywords:
- msi/MsiProcessAdvertiseScript
dev_langs:
- c++
req.header: msi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Installer 5.0 on Windows Server 2012, Windows 8, Windows Server 2008 R2 or Windows 7. Windows Installer 4.0 or Windows Installer 4.5 on   Windows Server 2008 or Windows Vista. Windows Installer on Windows Server 2003 or Windows XP. See the Windows Installer Run-Time Requirements for information about the minimum Windows service pack that is required by a Windows Installer version.
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: MsiProcessAdvertiseScriptW (Unicode) and MsiProcessAdvertiseScriptA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Msi.lib
req.dll: Msi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Msi.dll
api_name:
- MsiProcessAdvertiseScript
- MsiProcessAdvertiseScriptA
- MsiProcessAdvertiseScriptW
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# MsiProcessAdvertiseScriptW function


## -description


The 
<b>MsiProcessAdvertiseScript</b> function processes an advertise script file into the specified locations.


## -parameters




### -param szScriptFile [in]

The full path to a script file generated by 
<a href="https://docs.microsoft.com/windows/desktop/api/msi/nf-msi-msiadvertiseproducta">MsiAdvertiseProduct</a> or 
<a href="https://docs.microsoft.com/windows/desktop/api/msi/nf-msi-msiadvertiseproductexa">MsiAdvertiseProductEx</a>.


### -param szIconFolder [in]

An optional path to a folder in which advertised icon files and transform files are located. If this parameter is <b>NULL</b>, no icon or transform files are written.


### -param hRegData [in]

A registry key under which registry data is to be written. If this parameter is <b>NULL</b>, the installer writes the registry data under the appropriate key, based on whether the advertisement is per-user or per-machine. If this parameter is non-<b>NULL</b>, the script will write the registry data under the specified registry key rather than the normal location. In this case, the application will not get advertised to the user.


### -param fShortcuts [in]

<b>TRUE</b> if shortcuts should be created. If a special folder is returned by 
<a href="https://docs.microsoft.com/windows/desktop/api/shlobj_core/nf-shlobj_core-shgetspecialfolderlocation">SHGetSpecialFolderLocation</a> it will hold the shortcuts.


### -param fRemoveItems [in]

<b>TRUE</b> if specified items are to be removed instead of created.


## -returns



<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_SUCCESS</b></dt>
</dl>
</td>
<td width="60%">
The function completed successfully.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_ACCESS_DENIED</b></dt>
</dl>
</td>
<td width="60%">
The calling process was not running under the LocalSystem account.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>An error relating to an action</b></dt>
</dl>
</td>
<td width="60%">
See 
<a href="https://docs.microsoft.com/windows/desktop/Msi/error-codes">Error Codes</a>.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="https://docs.microsoft.com/windows/desktop/Msi/initialization-errors">Initialization Error</a></b></dt>
</dl>
</td>
<td width="60%">
An error relating to initialization occurred.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_CALL_NOT_IMPLEMENTED</b></dt>
</dl>
</td>
<td width="60%">
This function is not available for this platform.

</td>
</tr>
</table>
 


<div> </div>





## -remarks



The process calling this function must be running under the LocalSystem account. To advertise an application for per-user installation to a targeted user, the thread that calls this function must impersonate the targeted user. If the thread calling this function is not impersonating a targeted user, the application is advertised to all users for installation with elevated privileges.



