---
UID: NE:msinkaut.InkOverlayEditingMode
title: InkOverlayEditingMode (msinkaut.h)
description: Specifies the behavior mode of the InkOverlay object and the InkPicture control.
old-location: tablet\inkoverlayeditingmode.htm
tech.root: tablet
ms.assetid: de25636c-b8ca-47e4-ae16-182b98ede8f6
ms.date: 12/05/2018
ms.keywords: IOEM_Delete, IOEM_Ink, IOEM_Select, InkOverlayEditingMode, InkOverlayEditingMode enumeration [Tablet PC], de25636c-b8ca-47e4-ae16-182b98ede8f6, msinkaut/IOEM_Delete, msinkaut/IOEM_Ink, msinkaut/IOEM_Select, msinkaut/InkOverlayEditingMode, tablet.inkoverlayeditingmode
f1_keywords:
- msinkaut/InkOverlayEditingMode
dev_langs:
- c++
req.header: msinkaut.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- msinkaut.h
api_name:
- InkOverlayEditingMode
targetos: Windows
req.typenames: InkOverlayEditingMode
req.redist: 
ms.custom: 19H1
---

# InkOverlayEditingMode enumeration


## -description



Specifies the behavior mode of the <a href="https://docs.microsoft.com/windows/desktop/tablet/inkoverlay-class">InkOverlay</a> object and the <a href="https://docs.microsoft.com/windows/desktop/tablet/inkpicture-control-reference">InkPicture</a> control.




## -enum-fields




### -field IOEM_Ink

The object or control is in collection mode.


### -field IOEM_Delete

The object or control is in deletion mode.


### -field IOEM_Select

The object or control is in selection and editing mode.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkpicture-get_editingmode">EditingMode Property [InkPicture Control</a>



<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkpicture-get_erasermode">EraserMode Property [InkPicture Control]</a>



<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkpicture-get_eraserwidth">EraserWidth Property [InkPicture Control]</a>



<a href="https://docs.microsoft.com/windows/desktop/tablet/inkoverlay-class">InkOverlay Class</a>



<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/ne-msinkaut-inkoverlayerasermode">InkOverlayEraserMode Enumeration</a>



<a href="https://docs.microsoft.com/windows/desktop/tablet/inkpicture-control-reference">InkPicture Control Reference</a>
 

 

