---
UID: NE:msinkaut.ItemSelectionConstants
title: InkSelectionConstants (msinkaut.h)
description: Specifies whether the first element or all elements within a group of points or packet values are used.
old-location: tablet\itemselectionconstants.htm
tech.root: tablet
ms.assetid: 785b5ac7-b629-4948-a8bf-e92b74dacdb7
ms.date: 12/05/2018
ms.keywords: 785b5ac7-b629-4948-a8bf-e92b74dacdb7, ISC_AllElements, ISC_FirstElement, InkSelectionConstants, InkSelectionConstants enumeration [Tablet PC], ItemSelectionConstants, ItemSelectionConstants enumeration [Tablet PC], msinkaut/ISC_AllElements, msinkaut/ISC_FirstElement, msinkaut/ItemSelectionConstants, tablet.itemselectionconstants
f1_keywords:
- msinkaut/InkSelectionConstants
dev_langs:
- c++
req.header: msinkaut.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- msinkaut.h
api_name:
- InkSelectionConstants
targetos: Windows
req.typenames: InkSelectionConstants
req.redist: 
ms.custom: 19H1
---

# InkSelectionConstants enumeration


## -description



Specifies whether the first element or all elements within a group of points or packet values are used.




## -enum-fields




### -field ISC_FirstElement

The first element is used.


### -field ISC_AllElements

 All elements are used.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkstrokedisp-getpacketdata">GetPacketData Method [IInkStrokeDisp Interface]</a>



<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkstrokedisp-getpacketvaluesbyproperty">GetPacketValuesByProperty Method [IInkStrokeDisp Interface]</a>



<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkstrokedisp-getpoints">GetPoints Method [IInkStrokeDisp Interface]</a>



<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkstrokedisp-setpacketvaluesbyproperty">SetPacketValuesByProperty Method [IInkStrokeDisp Interface]</a>



<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkstrokedisp-setpoints">SetPoints Method [IInkStrokeDisp Interface]</a>
 

 

