---
UID: NF:msinkaut.IInkPicture.get_CollectionMode
title: IInkPicture::get_CollectionMode (msinkaut.h)
description: Gets or sets the collection mode that determines whether ink, gestures, or both are recognized as the user writes.
old-location: tablet\inkpicture_collectionmode.htm
tech.root: tablet
ms.assetid: fe3d1158-b99b-4ae1-a509-c6f34b42615f
ms.date: 12/05/2018
ms.keywords: CollectionMode property [Tablet PC], CollectionMode property [Tablet PC],IInkPicture interface, IInkPicture interface [Tablet PC],CollectionMode property, IInkPicture.CollectionMode, IInkPicture.get_CollectionMode, IInkPicture::CollectionMode, IInkPicture::get_CollectionMode, IInkPicture::put_CollectionMode, InkPicture.get_CollectionMode, InkPicture.put_CollectionMode, fe3d1158-b99b-4ae1-a509-c6f34b42615f, get_CollectionMode, msinkaut/IInkPicture::CollectionMode, msinkaut/IInkPicture::get_CollectionMode, msinkaut/IInkPicture::put_CollectionMode, tablet.inkpicture_collectionmode
f1_keywords:
- msinkaut/IInkPicture.CollectionMode
dev_langs:
- c++
req.header: msinkaut.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP Tablet PC Edition [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: InkObj.dll
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- InkObj.dll
- InkObj.dll.dll
api_name:
- IInkPicture.CollectionMode
- IInkPicture.get_CollectionMode
- IInkPicture.put_CollectionMode
- InkPicture.get_CollectionMode
- InkPicture.put_CollectionMode
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IInkPicture::get_CollectionMode


## -description



Gets or sets the collection mode that determines whether ink, gestures, or both are recognized as the user writes.



This property is read/write.


## -parameters


## -remarks



For a list of the modes that you can use, see the <a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/ne-msinkaut-inkcollectionmode">InkCollectionMode</a> enumeration type.

For further details about this property, refer to the <a href="https://docs.microsoft.com/windows/desktop/tablet/inkcollector-class">InkCollector</a> object's <a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkcollector-get_collectionmode">CollectionMode</a> property, which has the same functionality.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/nf-msinkaut-iinkpicture-get_collectingink">CollectingInk Property</a>



<a href="https://msdn.microsoft.com/en-us/library/Mt846800(v=VS.85).aspx">IInkPicture</a>



<a href="https://docs.microsoft.com/windows/desktop/api/msinkaut/ne-msinkaut-inkcollectionmode">InkCollectionMode Enumeration</a>



<a href="https://docs.microsoft.com/windows/desktop/tablet/inkpicture-control">InkPicture Control</a>
 

 

