---
UID: NF:mswmdm.IWMDMDevice3.FindStorage
title: IWMDMDevice3::FindStorage (mswmdm.h)
description: The FindStorage method finds a storage by its persistent unique identifier. Unlike other methods, this method can search recursively from the root storage.
old-location: wmdm\iwmdmdevice3_findstorage.htm
tech.root: WMDM
ms.assetid: 481e6c2d-4103-4818-9ad4-733629af9f9d
ms.date: 12/05/2018
ms.keywords: FindStorage, FindStorage method [windows Media Device Manager], FindStorage method [windows Media Device Manager],IWMDMDevice3 interface, IWMDMDevice3 interface [windows Media Device Manager],FindStorage method, IWMDMDevice3.FindStorage, IWMDMDevice3::FindStorage, IWMDMDevice3FindStorage, mswmdm/IWMDMDevice3::FindStorage, wmdm.iwmdmdevice3_findstorage
f1_keywords:
- mswmdm/IWMDMDevice3.FindStorage
dev_langs:
- c++
req.header: mswmdm.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Mssachlp.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- mssachlp.lib
- mssachlp.dll
api_name:
- IWMDMDevice3.FindStorage
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWMDMDevice3::FindStorage


## -description



The <b>FindStorage</b> method finds a storage by its persistent unique identifier. Unlike other methods, this method can search recursively from the root storage.




## -parameters




### -param findScope [in]

A <a href="https://docs.microsoft.com/windows/desktop/WMDM/wmdm-find-scope">WMDM_FIND_SCOPE</a> enumeration specifying the scope of the find operation.


### -param pwszUniqueID [in]

A wide character, null-terminated string representing a persistent unique identifier of the storage, which can be retrieved by querying for the <b>g_wszWMDMPersistentUniqueID</b> property of the storage.


### -param ppStorage [out]

Pointer to the returned storage. The caller must release this interface when done with it.


## -returns



The method returns an <b>HRESULT</b>. All the interface methods in Windows Media Device Manager can return any of the following classes of error codes:

<ul>
<li>Standard COM error codes </li>
<li>Windows error codes converted to HRESULT values </li>
<li>Windows Media Device Manager error codes </li>
</ul>
For an extensive list of possible error codes, see <a href="https://docs.microsoft.com/windows/desktop/WMDM/error-codes">Error Codes</a>.




## -remarks



A persistent unique identifier is used to uniquely identify content stored on a particular device. It does not represent a content-specific globally unique identifier that remains identical across all devices. Thus, the same content stored in different storages will have different persistent unique identifiers. Similarly, different content can have same persistent unique identifier when it is stored on different devices. Using the analogy of content on a device being similar to rows in a database, this property serves the same purpose as the identity column serves in a database.

Because it is generated by the device, the format of the persistent unique identifier is device-dependent. The application should get the persistent unique identifier by querying the <b>g_wszWMDMPersistentUniqueID</b> property of the storage. An application can use the <b>GetSpecifiedMetadata</b> or <b>GetMetadata</b> methods to query this property.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/mswmdm/nn-mswmdm-iwmdmdevice3">IWMDMDevice3 Interface</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mswmdm/nf-mswmdm-iwmdmstorage3-getmetadata">IWMDMStorage3::GetMetadata</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mswmdm/nf-mswmdm-iwmdmstorage4-findstorage">IWMDMStorage4::FindStorage</a>



<a href="https://docs.microsoft.com/windows/desktop/api/mswmdm/nf-mswmdm-iwmdmstorage4-getspecifiedmetadata">IWMDMStorage4::GetSpecifiedMetadata</a>



<a href="https://docs.microsoft.com/windows/desktop/WMDM/metadata-constants">Metadata Constants</a>



<a href="https://docs.microsoft.com/windows/desktop/WMDM/wmdm-find-scope">WMDM_FIND_SCOPE</a>
 

 

