---
UID: NF:ndhelper.INetDiagHelperEx.ReconfirmLowHealth
title: INetDiagHelperEx::ReconfirmLowHealth (ndhelper.h)
description: Used to add a second Low Health pass after hypotheses have been diagnosed and before repairs are retrieved.
old-location: ndf\inetdiaghelperex_reconfirmlowhealth.htm
tech.root: NDF
ms.assetid: 4ac1c901-cfc3-4ef6-aceb-d496179145b8
ms.date: 12/05/2018
ms.keywords: INetDiagHelperEx interface [NDF],ReconfirmLowHealth method, INetDiagHelperEx.ReconfirmLowHealth, INetDiagHelperEx::ReconfirmLowHealth, ReconfirmLowHealth, ReconfirmLowHealth method [NDF], ReconfirmLowHealth method [NDF],INetDiagHelperEx interface, ndf.inetdiaghelperex_reconfirmlowhealth, ndhelper/INetDiagHelperEx::ReconfirmLowHealth
f1_keywords:
- ndhelper/INetDiagHelperEx.ReconfirmLowHealth
dev_langs:
- c++
req.header: ndhelper.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Ndhelper.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- ndhelper.h
api_name:
- INetDiagHelperEx.ReconfirmLowHealth
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# INetDiagHelperEx::ReconfirmLowHealth


## -description


The <b>ReconfirmLowHealth</b> method is used to add a second Low Health pass after hypotheses have been diagnosed and before repairs are retrieved. This method allows the helper class to see the diagnostics results and to change the diagnosis if needed. The method is only called if a diagnosis is not rejected and hypotheses were generated.


## -parameters




### -param celt [in]

The number of <a href="https://docs.microsoft.com/windows/desktop/api/ndhelper/ns-ndhelper-hypothesisresult">HypothesisResult</a> structures pointed to by <i>pResults</i>.


### -param pResults [in]

Pointer to <a href="https://docs.microsoft.com/windows/desktop/api/ndhelper/ns-ndhelper-hypothesisresult">HypothesisResult</a> structure(s) containing the <a href="https://docs.microsoft.com/windows/desktop/api/ndhelper/ns-ndhelper-hypothesis">HYPOTHESIS</a> information obtained via the <a href="https://docs.microsoft.com/windows/desktop/api/ndhelper/nf-ndhelper-inetdiaghelper-getlowerhypotheses">GetLowerHypotheses</a> method along with the status of that hypothesis. Includes one <b>HypothesisResult</b> structure for each hypothesis generated by the helper class's call to <b>GetLowerHypotheses</b>.


### -param ppwszUpdatedDescription [out]

An updated description of the incident being diagnosed.


### -param pUpdatedStatus [out]

A <a href="https://docs.microsoft.com/windows/desktop/api/ndhelper/ne-ndhelper-diagnosis_status">DIAGNOSIS_STATUS</a> value which indicates the status of the incident.


## -returns



Possible return values include, but are not limited to, the following.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
The operation succeeded.

</td>
</tr>
</table>
 

Any result other than S_OK will be interpreted as an error and will cause the function results to be discarded.




## -remarks



This method is not required when building a Helper Class Extension.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/ndhelper/ne-ndhelper-diagnosis_status">DIAGNOSIS_STATUS</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ndhelper/ns-ndhelper-hypothesisresult">HypothesisResult</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ndhelper/nn-ndhelper-inetdiaghelperex">INetDiagHelperEx</a>
 

 

