---
UID: NF:netfw.INetFwIcmpSettings.put_AllowOutboundTimeExceeded
title: INetFwIcmpSettings::put_AllowOutboundTimeExceeded (netfw.h)
description: Indicates whether exceeding the outbound time is allowed.
old-location: ics\inetfwicmpsettings_allowoutboundtimeexceeded.htm
tech.root: ics
ms.assetid: b0a78d16-ce10-4978-bd66-e4841a4c52b6
ms.date: 12/05/2018
ms.keywords: AllowOutboundTimeExceeded property [ICS/ICF], AllowOutboundTimeExceeded property [ICS/ICF],INetFwIcmpSettings interface, INetFwIcmpSettings interface [ICS/ICF],AllowOutboundTimeExceeded property, INetFwIcmpSettings.AllowOutboundTimeExceeded, INetFwIcmpSettings.put_AllowOutboundTimeExceeded, INetFwIcmpSettings::AllowOutboundTimeExceeded, INetFwIcmpSettings::get_AllowOutboundTimeExceeded, INetFwIcmpSettings::put_AllowOutboundTimeExceeded, ics.inetfwicmpsettings_allowoutboundtimeexceeded, netfw/INetFwIcmpSettings::AllowOutboundTimeExceeded, netfw/INetFwIcmpSettings::get_AllowOutboundTimeExceeded, netfw/INetFwIcmpSettings::put_AllowOutboundTimeExceeded, put_AllowOutboundTimeExceeded
f1_keywords:
- netfw/INetFwIcmpSettings.AllowOutboundTimeExceeded
dev_langs:
- c++
req.header: netfw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: Windows Server 2003 with SP1 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: FirewallAPI.dll; Hnetcfg.dll on Windows XP with SP2
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- FirewallAPI.dll
- Hnetcfg.dll
api_name:
- INetFwIcmpSettings.AllowOutboundTimeExceeded
- INetFwIcmpSettings.get_AllowOutboundTimeExceeded
- INetFwIcmpSettings.put_AllowOutboundTimeExceeded
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# INetFwIcmpSettings::put_AllowOutboundTimeExceeded


## -description


<p class="CCE_Message">[The Windows Firewall API is available for use in the operating systems specified in the Requirements section. It may be altered or unavailable in subsequent versions. For Windows Vista and later, use of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-advanced-security-start-page">Windows Firewall with Advanced Security</a> API is recommended.]

Indicates whether exceeding the outbound time is allowed.

This property is read/write.


## -parameters


## -remarks



This setting is common to IPv4 and IPv6.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/netfw/nn-netfw-inetfwicmpsettings">INetFwIcmpSettings</a>
 

 

