---
UID: NF:netfw.INetFwRule3.put_SecureFlags
title: INetFwRule3::put_SecureFlags (netfw.h)
description: Specifies which firewall verifications of security levels provided by IPsec must be guaranteed to allow the collection. The allowed values must correspond to those of the NET_FW_AUTHENTICATE_TYPE enumeration.
old-location: ics\inetfwrule3_secureflags.htm
tech.root: ics
ms.assetid: 3efb3491-f030-4a0a-bfbd-ab18fd424a38
ms.date: 12/05/2018
ms.keywords: INetFwRule3 interface [ICS/ICF],SecureFlags property, INetFwRule3.SecureFlags, INetFwRule3.put_SecureFlags, INetFwRule3::SecureFlags, INetFwRule3::get_SecureFlags, INetFwRule3::put_SecureFlags, SecureFlags property [ICS/ICF], SecureFlags property [ICS/ICF],INetFwRule3 interface, ics.inetfwrule3_secureflags, netfw/INetFwRule3::SecureFlags, netfw/INetFwRule3::get_SecureFlags, netfw/INetFwRule3::put_SecureFlags, put_SecureFlags
f1_keywords:
- netfw/INetFwRule3.SecureFlags
dev_langs:
- c++
req.header: netfw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps only]
req.target-min-winversvr: Windows Server 2012 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: FirewallAPI.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- FirewallAPI.dll
api_name:
- INetFwRule3.SecureFlags
- INetFwRule3.get_SecureFlags
- INetFwRule3.put_SecureFlags
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# INetFwRule3::put_SecureFlags


## -description


Specifies which firewall verifications of security levels provided by IPsec must be guaranteed to allow the collection. The allowed values must correspond to those of the <a href="/windows/win32/api/icftypes/ne-icftypes-net_fw_authenticate_type">NET_FW_AUTHENTICATE_TYPE</a> enumeration.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/netfw/nn-netfw-inetfwrule3">INetFwRule3</a>



<a href="/windows/win32/api/icftypes/ne-icftypes-net_fw_authenticate_type">NET_FW_AUTHENTICATE_TYPE</a>
 

 

