---
UID: NF:netfw.INetFwService.get_GloballyOpenPorts
title: INetFwService::get_GloballyOpenPorts (netfw.h)
description: Retrieves the collection of globally open ports associated with the service.
old-location: ics\inetfwservice_globallyopenports.htm
tech.root: ics
ms.assetid: 51f0440f-6e0c-48b2-9dc0-bec503192fa1
ms.date: 12/05/2018
ms.keywords: GloballyOpenPorts property [ICS/ICF], GloballyOpenPorts property [ICS/ICF],INetFwService interface, INetFwService interface [ICS/ICF],GloballyOpenPorts property, INetFwService.GloballyOpenPorts, INetFwService.get_GloballyOpenPorts, INetFwService::GloballyOpenPorts, INetFwService::get_GloballyOpenPorts, get_GloballyOpenPorts, ics.inetfwservice_globallyopenports, netfw/INetFwService::GloballyOpenPorts, netfw/INetFwService::get_GloballyOpenPorts
f1_keywords:
- netfw/INetFwService.GloballyOpenPorts
dev_langs:
- c++
req.header: netfw.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista, Windows XP with SP2 [desktop apps only]
req.target-min-winversvr: Windows Server 2003 with SP1 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: FirewallAPI.dll; Hnetcfg.dll on Windows XP with SP2
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- FirewallAPI.dll
- Hnetcfg.dll
api_name:
- INetFwService.GloballyOpenPorts
- INetFwService.get_GloballyOpenPorts
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# INetFwService::get_GloballyOpenPorts


## -description


<p class="CCE_Message">[The Windows Firewall API is available for use in the operating systems specified in the Requirements section. It may be altered or unavailable in subsequent versions. For Windows Vista and later, use of the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ics/windows-firewall-advanced-security-start-page">Windows Firewall with Advanced Security</a> API is recommended.]

Retrieves the collection of globally open ports associated with the service.

This property is read-only.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/netfw/nn-netfw-inetfwopenports">INetFwOpenPorts</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/netfw/nn-netfw-inetfwservice">INetFwService</a>
 

 

