---
UID: NE:ntdsapi.__unnamed_enum_7
title: DS_KCC_TASKID (ntdsapi.h)
description: Specifies tasks that Knowledge Consistency Checker (KCC) can execute.
old-location: ad\ds_kcc_taskid.htm
tech.root: ad
ms.assetid: 61A2BB61-E3AE-4530-96CA-E7F85CB82DB2
ms.date: 12/05/2018
ms.keywords: DS_KCC_TASKID, DS_KCC_TASKID enumeration [Active Directory], DS_KCC_TASKID_UPDATE_TOPOLOGY, ad.ds_kcc_taskid, ntdsapi/DS_KCC_TASKID, ntdsapi/DS_KCC_TASKID_UPDATE_TOPOLOGY
f1_keywords:
- ntdsapi/DS_KCC_TASKID
dev_langs:
- c++
req.header: ntdsapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ntdsapi.h
api_name:
- DS_KCC_TASKID
targetos: Windows
req.typenames: DS_KCC_TASKID
req.redist: 
ms.custom: 19H1
---

# DS_KCC_TASKID enumeration


## -description


Specifies tasks that Knowledge Consistency Checker (KCC) can execute.


## -enum-fields




### -field DS_KCC_TASKID_UPDATE_TOPOLOGY

Dynamically adjusts the data replication topology of a network.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/nf-ntdsapi-dsreplicaconsistencycheck">DsReplicaConsistencyCheck</a>



<a href="https://docs.microsoft.com/windows/desktop/AD/enumerations-in-active-directory-domain-services">Enumerations in Active Directory Domain Services</a>
 

 

