---
UID: NS:ntdsapi.__unnamed_struct_7
title: DS_REPSYNCALL_ERRINFOW (ntdsapi.h)
description: The DS_REPSYNCALL_ERRINFO structure is used with the DS_REPSYNCALL_UPDATE structure to contain errors generated by the DsReplicaSyncAll function during replication.
old-location: ad\ds_repsyncall_errinfo.htm
tech.root: ad
ms.assetid: 70af4e3e-1f0e-49c5-b8c6-5e89114ed4ea
ms.date: 12/05/2018
ms.keywords: '*PDS_REPSYNCALL_ERRINFOW, DS_REPSYNCALL_ERRINFO, DS_REPSYNCALL_ERRINFO structure [Active Directory], DS_REPSYNCALL_ERRINFOA, DS_REPSYNCALL_ERRINFOW, PDS_REPSYNCALL_ERRINFO, PDS_REPSYNCALL_ERRINFO structure pointer [Active Directory], _glines_ds_repsyncall_errinfo, ad.ds__repsyncall__errinfo, ad.ds_repsyncall_errinfo, ntdsapi/DS_REPSYNCALL_ERRINFO, ntdsapi/DS_REPSYNCALL_ERRINFOA, ntdsapi/DS_REPSYNCALL_ERRINFOW, ntdsapi/PDS_REPSYNCALL_ERRINFO'
f1_keywords:
- ntdsapi/DS_REPSYNCALL_ERRINFO
dev_langs:
- c++
req.header: ntdsapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: DS_REPSYNCALL_ERRINFOW (Unicode) and DS_REPSYNCALL_ERRINFOA (ANSI)
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ntdsapi.h
api_name:
- DS_REPSYNCALL_ERRINFO
- DS_REPSYNCALL_ERRINFOA
- DS_REPSYNCALL_ERRINFOW
targetos: Windows
req.typenames: DS_REPSYNCALL_ERRINFOW, *PDS_REPSYNCALL_ERRINFOW
req.redist: 
ms.custom: 19H1
---

# DS_REPSYNCALL_ERRINFOW structure


## -description


The <b>DS_REPSYNCALL_ERRINFO</b> structure is used with the <a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/ns-ntdsapi-ds_repsyncall_updatea">DS_REPSYNCALL_UPDATE</a> structure to contain errors generated by the 
<a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/nf-ntdsapi-dsreplicasyncalla">DsReplicaSyncAll</a> function during replication.


## -struct-fields




### -field pszSvrId

Pointer to a null-terminated string that contains the DNS GUID of the server where the error occurred. Alternatively, this member can contain the distinguished name of the server if <b>DS_REPSYNCALL_ID_SERVERS_BY_DN</b> is specified in the <i>ulFlags</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/nf-ntdsapi-dsreplicasyncalla">DsReplicaSyncAll</a> function.


### -field error

Contains one of the <a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/ne-ntdsapi-ds_repsyncall_error">DS_REPSYNCALL_ERROR</a> values that indicates where in the replication process the error occurred.


### -field dwWin32Err

Indicates the actual Win32 error code generated during replication between the source server referred to by <b>pszSrcId</b> and the destination server referred to by <b>pszSvrId</b>.


### -field pszSrcId

Pointer to a null-terminated string that specifies the DNS GUID of the source server. Alternatively, this member can contain the distinguished name of the source server if <b>DS_REPSYNCALL_ID_SERVERS_BY_DN</b> is specified in the <i>ulFlags</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/nf-ntdsapi-dsreplicasyncalla">DsReplicaSyncAll</a> function.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/ne-ntdsapi-ds_repsyncall_error">DS_REPSYNCALL_ERROR</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/ns-ntdsapi-ds_repsyncall_updatea">DS_REPSYNCALL_UPDATE</a>



<a href="https://docs.microsoft.com/windows/desktop/AD/domain-controller-and-replication-management-structures">Domain Controller and Replication Management Structures</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ntdsapi/nf-ntdsapi-dsreplicasyncalla">DsReplicaSyncAll</a>
 

 

