---
UID: NS:ntenclv.VBS_ENCLAVE_REPORT
title: VBS_ENCLAVE_REPORT (ntenclv.h)
description: Describes the format of the signed statement contained in a report generated by calling the EnclaveGetAttestationReport function.
old-location: base\vbs_enclave_report.htm
tech.root: Memory
ms.assetid: 90D6E8D2-191B-41D2-8C75-28A26462644B
ms.date: 12/05/2018
ms.keywords: VBS_ENCLAVE_REPORT, VBS_ENCLAVE_REPORT structure, base.vbs_enclave_report, ntenclv/VBS_ENCLAVE_REPORT
f1_keywords:
- ntenclv/VBS_ENCLAVE_REPORT
dev_langs:
- c++
req.header: ntenclv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1709 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ntenclv.h
api_name:
- VBS_ENCLAVE_REPORT
targetos: Windows
req.typenames: VBS_ENCLAVE_REPORT
req.redist: 
ms.custom: 19H1
---

# VBS_ENCLAVE_REPORT structure


## -description


Describes the format of the signed statement contained in a report generated by calling the <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> function.


## -struct-fields




### -field ReportSize

The total size of the signed statement in the report, including the sizes of the <b>VBS_ENCLAVE_REPORT</b> structure and of all the variable data blocks, in bytes.


### -field ReportVersion

The version of the report format.  The only currently available version is  <b>VBS_ENCLAVE_REPORT_VERSION_CURRENT</b>, which equals 1.


### -field EnclaveData

The 64 bytes that were provided in <i>EnclaveData</i> parameter of the <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> function.


### -field EnclaveIdentity

An <a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-enclave_identity">ENCLAVE_IDENTITY</a> structure that describes the identity of the primary module of the enclave. 


## -remarks



The signed statement in an enclave attestation report consist of the following items:

<ul>
<li>
A <b>VBS_ENCLAVE_REPORT</b> structure the describes the format of the signed statement.

</li>
<li>
Zero or more variable data blocks that consist of the following items:

<ul>
<li>A <a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-vbs_enclave_report_vardata_header">VBS_ENCLAVE_REPORT_VARDATA_HEADER</a> structure that describes the format of the variable data block.</li>
<li>Data described by the <a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-vbs_enclave_report_vardata_header">VBS_ENCLAVE_REPORT_VARDATA_HEADER</a> structure.</li>
</ul>
</li>
</ul>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-enclave_identity">ENCLAVE_IDENTITY</a>



<a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a>
 

 

