---
UID: NS:ntenclv.VBS_ENCLAVE_REPORT_PKG_HEADER
title: VBS_ENCLAVE_REPORT_PKG_HEADER (ntenclv.h)
description: Describes the contents of a report generated by calling the EnclaveGetAttestationReport function.
old-location: base\vbs_enclave_report_pkg_header.htm
tech.root: Memory
ms.assetid: F2E24F81-97F1-404E-9974-327C762683DA
ms.date: 12/05/2018
ms.keywords: VBS_ENCLAVE_REPORT_PKG_HEADER, VBS_ENCLAVE_REPORT_PKG_HEADER structure, base.vbs_enclave_report_pkg_header, ntenclv/VBS_ENCLAVE_REPORT_PKG_HEADER
f1_keywords:
- ntenclv/VBS_ENCLAVE_REPORT_PKG_HEADER
dev_langs:
- c++
req.header: ntenclv.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1709 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- ntenclv.h
api_name:
- VBS_ENCLAVE_REPORT_PKG_HEADER
targetos: Windows
req.typenames: VBS_ENCLAVE_REPORT_PKG_HEADER
req.redist: 
ms.custom: 19H1
---

# VBS_ENCLAVE_REPORT_PKG_HEADER structure


## -description


Describes the contents of a report generated by calling the <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> function.


## -struct-fields




### -field PackageSize

The sum of the sizes of the  <b>VBS_ENCLAVE_REPORT_PKG_HEADER</b> structure, the signed statement, and the signature contained in a report generated by calling the <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> function, in bytes.


### -field Version

The version of the <b>VBS_ENCLAVE_REPORT_PKG_HEADER</b> structure in a report generated by calling the <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> function. The only version currently supported is <b>VBS_ENCLAVE_REPORT_PKG_HEADER_VERSION_CURRENT</b>, which equals 1.


### -field SignatureScheme

The scheme used for the signature in a report generated by calling the <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> function.


### -field SignedStatementSize

The size of the signed data contained in a report generated by calling the <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> function, in bytes.


### -field SignatureSize

The size of the signature contained in a report generated by calling the <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> function, in bytes.


### -field Reserved

Reserved.


## -remarks



The report that <a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a> generates consists of the following items:

<ul>
<li>
A <b>VBS_ENCLAVE_REPORT_PKG_HEADER</b> structure

</li>
<li>
A signed statement that consist of the following items:

<ul>
<li>
A <a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-vbs_enclave_report">VBS_ENCLAVE_REPORT</a> structure

</li>
<li>
Zero or more variable data blocks that consist of the following items:

<ul>
<li>A <a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-vbs_enclave_report_vardata_header">VBS_ENCLAVE_REPORT_VARDATA_HEADER</a> structure</li>
<li>Data described by the <a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-vbs_enclave_report_vardata_header">VBS_ENCLAVE_REPORT_VARDATA_HEADER</a> structure</li>
</ul>
</li>
</ul>
</li>
<li>A signature</li>
</ul>



## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/winenclaveapi/nf-winenclaveapi-enclavegetattestationreport">EnclaveGetAttestationReport</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-vbs_enclave_report">VBS_ENCLAVE_REPORT</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ntenclv/ns-ntenclv-vbs_enclave_report_vardata_header">VBS_ENCLAVE_REPORT_VARDATA_HEADER</a>
 

 

