---
UID: NE:ntsecapi._KERB_PROTOCOL_MESSAGE_TYPE
title: KERB_PROTOCOL_MESSAGE_TYPE (ntsecapi.h)
description: Lists the types of messages that can be sent to the Kerberos authentication package by calling the LsaCallAuthenticationPackage function.
old-location: security\kerb_protocol_message_type.htm
tech.root: SecAuthN
ms.assetid: 8ad183d2-3fe8-4f52-bfa4-16f2a711f0c3
ms.date: 12/05/2018
ms.keywords: '*PKERB_PROTOCOL_MESSAGE_TYPE, KERB_PROTOCOL_MESSAGE_TYPE, KERB_PROTOCOL_MESSAGE_TYPE enumeration [Security], KerbAddBindingCacheEntryExMessage, KerbAddBindingCacheEntryMessage, KerbAddExtraCredentialsExMessage, KerbAddExtraCredentialsMessage, KerbChangeMachinePasswordMessage, KerbChangePasswordMessage, KerbCleanupMachinePkinitCredsMessage, KerbDebugRequestMessage, KerbDecryptDataMessage, KerbPurgeBindingCacheMessage, KerbPurgeKdcProxyCacheMessage, KerbPurgeTicketCacheExMessage, KerbPurgeTicketCacheMessage, KerbQueryBindingCacheMessage, KerbQueryDomainExtendedPoliciesMessage, KerbQueryKdcProxyCacheMessage, KerbQueryS4U2ProxyCacheMessage, KerbQuerySupplementalCredentialsMessage, KerbQueryTicketCacheEx2Message, KerbQueryTicketCacheEx3Message, KerbQueryTicketCacheExMessage, KerbQueryTicketCacheMessage, KerbRefreshSmartcardCredentialsMessage, KerbRetrieveEncodedTicketMessage, KerbRetrieveTicketMessage, KerbSetPasswordExMessage, KerbSetPasswordMessage, KerbSubmitTicketMessage, KerbTransferCredentialsMessage, KerbUpdateAddressesMessage, KerbVerifyCredentialsMessage, KerbVerifyPacMessage, PKERB_PROTOCOL_MESSAGE_TYPE, PKERB_PROTOCOL_MESSAGE_TYPE enumeration pointer [Security], _lsa_kerb_protocol_message_type, ntsecapi/KERB_PROTOCOL_MESSAGE_TYPE, ntsecapi/KerbAddBindingCacheEntryExMessage, ntsecapi/KerbAddBindingCacheEntryMessage, ntsecapi/KerbAddExtraCredentialsExMessage, ntsecapi/KerbAddExtraCredentialsMessage, ntsecapi/KerbChangeMachinePasswordMessage, ntsecapi/KerbChangePasswordMessage, ntsecapi/KerbCleanupMachinePkinitCredsMessage, ntsecapi/KerbDebugRequestMessage, ntsecapi/KerbDecryptDataMessage, ntsecapi/KerbPurgeBindingCacheMessage, ntsecapi/KerbPurgeKdcProxyCacheMessage, ntsecapi/KerbPurgeTicketCacheExMessage, ntsecapi/KerbPurgeTicketCacheMessage, ntsecapi/KerbQueryBindingCacheMessage, ntsecapi/KerbQueryDomainExtendedPoliciesMessage, ntsecapi/KerbQueryKdcProxyCacheMessage, ntsecapi/KerbQueryS4U2ProxyCacheMessage, ntsecapi/KerbQuerySupplementalCredentialsMessage, ntsecapi/KerbQueryTicketCacheEx2Message, ntsecapi/KerbQueryTicketCacheEx3Message, ntsecapi/KerbQueryTicketCacheExMessage, ntsecapi/KerbQueryTicketCacheMessage, ntsecapi/KerbRefreshSmartcardCredentialsMessage, ntsecapi/KerbRetrieveEncodedTicketMessage, ntsecapi/KerbRetrieveTicketMessage, ntsecapi/KerbSetPasswordExMessage, ntsecapi/KerbSetPasswordMessage, ntsecapi/KerbSubmitTicketMessage, ntsecapi/KerbTransferCredentialsMessage, ntsecapi/KerbUpdateAddressesMessage, ntsecapi/KerbVerifyCredentialsMessage, ntsecapi/KerbVerifyPacMessage, ntsecapi/PKERB_PROTOCOL_MESSAGE_TYPE, security.kerb_protocol_message_type'
f1_keywords:
- ntsecapi/KERB_PROTOCOL_MESSAGE_TYPE
dev_langs:
- c++
req.header: ntsecapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Ntsecapi.h
api_name:
- KERB_PROTOCOL_MESSAGE_TYPE
targetos: Windows
req.typenames: KERB_PROTOCOL_MESSAGE_TYPE, *PKERB_PROTOCOL_MESSAGE_TYPE
req.redist: 
ms.custom: 19H1
---

# KERB_PROTOCOL_MESSAGE_TYPE enumeration


## -description


The <b>KERB_PROTOCOL_MESSAGE_TYPE</b> enumeration lists the types of messages that can be sent to the <a href="https://docs.microsoft.com/windows/desktop/SecGloss/k-gly">Kerberos</a> authentication package by calling 
the <a href="https://docs.microsoft.com/windows/desktop/api/ntsecapi/nf-ntsecapi-lsacallauthenticationpackage">LsaCallAuthenticationPackage</a> function.

Each message corresponds to a dispatch routine and causes the Kerberos authentication package to perform a different task.


## -enum-fields




### -field KerbDebugRequestMessage

Reserved.


### -field KerbQueryTicketCacheMessage

This dispatch routine returns information about all of the cached tickets for the specified user <a href="https://docs.microsoft.com/windows/desktop/SecGloss/l-gly">logon session</a>.


### -field KerbChangeMachinePasswordMessage

This constant is reserved.


### -field KerbVerifyPacMessage

This constant is reserved.


### -field KerbRetrieveTicketMessage

This dispatch routine retrieves the ticket-granting ticket from the ticket cache of the specified user logon session.


### -field KerbUpdateAddressesMessage

This constant is reserved.


### -field KerbPurgeTicketCacheMessage

This dispatch routine allows selected tickets to be removed from the user logon session's ticket cache. It can also remove all cached tickets.


### -field KerbChangePasswordMessage

This message causes the use of Kerberos Password Change Protocol to change the user's password in a Windows domain or configured non-Windows Kerberos realm that supports this service. The caller must know the current password to change the password for an account. 




When changing the password of an account in a  non-Windows Kerberos realm, the local computer's registry is consulted to locate the Kerberos password service for the requested domain name.


### -field KerbRetrieveEncodedTicketMessage

This message retrieves the specified ticket, either from the cache, if it is already there, or by requesting it from the Kerberos key distribution center (KDC).


### -field KerbDecryptDataMessage

This constant is reserved.


### -field KerbAddBindingCacheEntryMessage

This constant is reserved.


### -field KerbSetPasswordMessage

This message uses a modified Kerberos Password Change Protocol to change the user's password in the domain or configured non-Windows Kerberos realm that supports this service. The caller must have permission  to set the password for the target account. The caller does not need to know the current password for the account. 




When changing the password for an account in a  non-Windows Kerberos realm, the local computer registry is used to locate the Kerberos password service for the requested domain name.


### -field KerbSetPasswordExMessage

This message extends <b>KerbSetPasswordMessage</b> by specifying the client name and realm.


### -field KerbAddExtraCredentialsMessage

This message is to add, remove, or replace an extra credential. The <b>SeTcbPrivilege</b> is required to alter another logon account's credentials.


### -field KerbQueryTicketCacheExMessage

This message extends <b>KerbQueryTicketCacheMessage</b> by specifying the client name and realm.


### -field KerbPurgeTicketCacheExMessage

This message extends <b>KerbPurgeTicketCacheMessage</b> by specifying the client name and realm.


### -field KerbRefreshSmartcardCredentialsMessage

This message is a request to refresh the smart card credentials.


### -field KerbQuerySupplementalCredentialsMessage

This constant is reserved.


### -field KerbTransferCredentialsMessage

The dispatch routine transfers credentials from one <a href="https://docs.microsoft.com/windows/desktop/api/winnt/ns-winnt-luid">LUID</a> to another <b>LUID</b>. The <b>SeTcbPrivilege</b> is required. 


<b>Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbQueryTicketCacheEx2Message

The dispatch routine queries the Kerberos ticket cache for the specified logon session. The session key type and branch ID are returned in addition to the other information returned when using the  <b>KerbQueryTicketCacheMessage</b> message type. The <b>SeTcbPrivilege</b> is required. 


<b>Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbSubmitTicketMessage

The dispatch routine gets the tickets from the KDC and updates the ticket cache. The <b>SeTcbPrivilege</b> is required to access another logon account's ticket cache. 


<b>Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbAddExtraCredentialsExMessage

The dispatch routine adds, modifies, or deletes an extra credential in one or more <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">service principal names</a> (SPNs). The <b>SeTcbPrivilege</b> is required to change extra credentials in another user's logon session.

<b>Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbQueryKdcProxyCacheMessage

This message returned information about the KDC proxy cached tickets.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbPurgeKdcProxyCacheMessage

This message allows selected KDC proxy tickets to be removed.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbQueryTicketCacheEx3Message

The dispatch routine queries the Kerberos ticket cache for the specified logon session. The number of tickets information is returned in addition to the other information returned when using the  <b>KerbQueryTicketCacheEx2Message</b> message type. The <b>SeTcbPrivilege</b> is required. 


<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbCleanupMachinePkinitCredsMessage

This message is to clean up and remove any PKINIT device credentials from the computer.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbAddBindingCacheEntryExMessage

This message is for adding a binding cache entry. The <b>SeTcbPrivilege</b> is required. 
 

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbQueryBindingCacheMessage

This message queries the binding cache for the number of entries and their data.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbPurgeBindingCacheMessage

This message is to clean up entries in the binding cache.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbPinKdcMessage


### -field KerbUnpinAllKdcsMessage


### -field KerbQueryDomainExtendedPoliciesMessage

This message queries for a list of the extended domain policies.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


### -field KerbQueryS4U2ProxyCacheMessage

This message queries the proxy cache for the information about a service for user (S4U) logon.

<b>Windows Server 2008, Windows Vista, Windows Server 2003 and Windows XP:  </b>This constant is not supported.


#### - KerbVerifyCredentialsMessage

This constant is reserved.

