---
UID: NC:ntsecpkg.LSA_AP_LOGON_TERMINATED
title: LSA_AP_LOGON_TERMINATED (ntsecpkg.h)
description: Used to notify an authentication package when a logon session terminates. A logon session terminates when the last token referencing the logon session is deleted.
old-location: security\lsaaplogonterminated.htm
tech.root: SecAuthN
ms.assetid: 17e8426a-5a25-48ca-8cef-91bbeda8490c
ms.date: 12/05/2018
ms.keywords: LSA_AP_LOGON_TERMINATED, LSA_AP_LOGON_TERMINATED callback, LsaApLogonTerminated, LsaApLogonTerminated callback function [Security], _lsa_lsaaplogonterminated, ntsecpkg/LsaApLogonTerminated, security.lsaaplogonterminated
f1_keywords:
- ntsecpkg/LsaApLogonTerminated
dev_langs:
- c++
req.header: ntsecpkg.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- UserDefined
api_location:
- Ntsecpkg.h
api_name:
- LsaApLogonTerminated
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# LSA_AP_LOGON_TERMINATED callback function


## -description


Used to notify an authentication package when a logon session terminates.
			A logon session terminates when the last token referencing the logon session is deleted.


## -parameters




### -param LogonId [in]

Pointer to the logon ID of the session that just ended.


## -returns



This function does not return a value.




## -remarks



When <b>LsaApLogonTerminated</b> is called, an authentication package should release any resources held for the logon ID, such as credentials created within the LSA. The LSA does not automatically perform this cleanup.



