---
UID: NC:ntsecpkg.SpImportSecurityContextFn
title: SpImportSecurityContextFn (ntsecpkg.h)
description: Imports a security context from another process.
old-location: security\spimportsecuritycontext.htm
tech.root: SecAuthN
ms.assetid: f3a9427b-37f0-464a-9f67-3b4e09597a98
ms.date: 12/05/2018
ms.keywords: SpImportSecurityContext, SpImportSecurityContext callback function [Security], SpImportSecurityContextFn, SpImportSecurityContextFn callback, _ssp_spimportsecuritycontext, ntsecpkg/SpImportSecurityContext, security.spimportsecuritycontext
f1_keywords:
- ntsecpkg/SpImportSecurityContext
dev_langs:
- c++
req.header: ntsecpkg.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- UserDefined
api_location:
- Ntsecpkg.h
api_name:
- SpImportSecurityContext
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# SpImportSecurityContextFn callback function


## -description


The <b>SpImportSecurityContext</b> function imports a security context from another process.

The <b>SpImportSecurityContext</b> function is the dispatch function for the 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/nf-sspi-importsecuritycontexta">ImportSecurityContext</a> function of the 
<a href="https://docs.microsoft.com/windows/desktop/SecAuthN/sspi">Security Support Provider Interface</a>.


## -parameters




### -param pPackedContext [in]

Pointer to a 
<a href="https://docs.microsoft.com/windows/desktop/api/sspi/ns-sspi-secbuffer">SecBuffer</a> structure containing a <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">serialized</a> <a href="https://docs.microsoft.com/windows/desktop/SecGloss/s-gly">security context</a> previously generated by the 
<a href="https://docs.microsoft.com/windows/desktop/api/ntsecpkg/nc-ntsecpkg-spexportsecuritycontextfn">SpExportSecurityContext</a> function.


### -param Token [in]

Optional. Handle to the context token.


### -param phContext [out]

Pointer to an <b>LSA_SEC_HANDLE</b> that receives the imported context handle.


## -returns



If the function succeeds, return STATUS_SUCCESS.

If the function fails, return an <b>NTSTATUS</b> code that indicates the reason it failed.




## -remarks



SSP/APs must implement the <b>SpImportSecurityContext</b> function; however, the actual name given to the implementation is up to the developer.

A pointer to the <b>SpImportSecurityContext</b> function is available in the 
<a href="https://docs.microsoft.com/windows/desktop/api/ntsecpkg/ns-ntsecpkg-secpkg_user_function_table">SECPKG_USER_FUNCTION_TABLE</a> structure received from the 
<a href="https://docs.microsoft.com/windows/desktop/api/ntsecpkg/nc-ntsecpkg-spusermodeinitializefn">SpUserModeInitialize</a> function.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/ntsecpkg/ns-ntsecpkg-secpkg_user_function_table">SECPKG_USER_FUNCTION_TABLE</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ntsecpkg/nc-ntsecpkg-spexportsecuritycontextfn">SpExportSecurityContext</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ntsecpkg/nc-ntsecpkg-spusermodeinitializefn">SpUserModeInitialize</a>
 

 

