---
UID: NE:objidl.CO_MARSHALING_CONTEXT_ATTRIBUTES
title: CO_MARSHALING_CONTEXT_ATTRIBUTES (objidl.h)
description: Identifies one of the marshaling context attributes that you can query by using the GetMarshalingContextAttribute method.
old-location: com\co_marshaling_context_attributes.htm
tech.root: com
ms.assetid: EF020513-8E03-474C-BC14-9E9D6EFE7318
ms.date: 12/05/2018
ms.keywords: CO_MARSHALING_CONTEXT_ATTRIBUTES, CO_MARSHALING_CONTEXT_ATTRIBUTES enumeration [COM], CO_MARSHALING_SOURCE_IS_APP_CONTAINER, com.co_marshaling_context_attributes, objidl/CO_MARSHALING_CONTEXT_ATTRIBUTES, objidl/CO_MARSHALING_SOURCE_IS_APP_CONTAINER
f1_keywords:
- objidl/CO_MARSHALING_CONTEXT_ATTRIBUTES
dev_langs:
- c++
req.header: objidl.h
req.include-header: Objidlbase.h
req.target-type: Windows
req.target-min-winverclnt: Windows 8
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Objidlbase.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- objidl.h
api_name:
- CO_MARSHALING_CONTEXT_ATTRIBUTES
targetos: Windows
req.typenames: CO_MARSHALING_CONTEXT_ATTRIBUTES
req.redist: 
ms.custom: 19H1
---

# CO_MARSHALING_CONTEXT_ATTRIBUTES enumeration


## -description


Identifies one of the marshaling context attributes that you can query by using the <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imarshalingstream-getmarshalingcontextattribute">GetMarshalingContextAttribute</a> method.


## -enum-fields




### -field CO_MARSHALING_SOURCE_IS_APP_CONTAINER

The source of the marshaling data is an app container process.


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_1


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_2


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_3


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_4


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_5


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_6


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_7


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_8


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_9


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_10


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_11


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_12


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_13


### -field CO_MARSHALING_CONTEXT_ATTRIBUTE_RESERVED_14




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imarshalingstream-getmarshalingcontextattribute">GetMarshalingContextAttribute</a>



<a href="https://docs.microsoft.com/windows/desktop/api/objidl/nn-objidl-imarshalingstream">IMarshalingStream</a>
 

 

