---
UID: NF:objidl.IApartmentShutdown.OnUninitialize
title: IApartmentShutdown::OnUninitialize (objidl.h)
description: Called when a registered apartment is shut down.
old-location: winrt\iapartmentshutdown_onuninitialize.htm
tech.root: WinRT
ms.assetid: FAEBC952-EDCB-4855-AB2B-193B87E3ECF7
ms.date: 12/05/2018
ms.keywords: IApartmentShutdown interface [Windows Runtime],OnUninitialize method, IApartmentShutdown.OnUninitialize, IApartmentShutdown::OnUninitialize, OnUninitialize, OnUninitialize method [Windows Runtime], OnUninitialize method [Windows Runtime],IApartmentShutdown interface, objidl/IApartmentShutdown::OnUninitialize, winrt.iapartmentshutdown_onuninitialize
f1_keywords:
- objidl/IApartmentShutdown.OnUninitialize
dev_langs:
- c++
req.header: objidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 8 [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2012 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- objidl.h
api_name:
- IApartmentShutdown.OnUninitialize
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IApartmentShutdown::OnUninitialize


## -description


Called when a registered apartment is shut down.


## -parameters




### -param ui64ApartmentIdentifier [in]

The apartment Identifier of the apartment that is shutting down


## -returns



This method does not return a value.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/objidl/nn-objidl-iapartmentshutdown">IApartmentShutdown</a>



<a href="https://docs.microsoft.com/windows/desktop/api/roapi/nf-roapi-roregisterforapartmentshutdown">RoRegisterForApartmentShutdown</a>
 

 

