---
UID: NF:objidl.IMarshal.GetMarshalSizeMax
title: IMarshal::GetMarshalSizeMax (objidl.h)
description: Retrieves the maximum size of the buffer that will be needed during marshaling.
old-location: com\imarshal_getmarshalsizemax.htm
tech.root: com
ms.assetid: 25ec060a-ec46-4857-8d66-8f8bb58d6d31
ms.date: 12/05/2018
ms.keywords: GetMarshalSizeMax, GetMarshalSizeMax method [COM], GetMarshalSizeMax method [COM],IMarshal interface, IMarshal interface [COM],GetMarshalSizeMax method, IMarshal.GetMarshalSizeMax, IMarshal::GetMarshalSizeMax, _com_imarshal_getmarshalsizemax, com.imarshal_getmarshalsizemax, objidl/IMarshal::GetMarshalSizeMax
f1_keywords:
- objidl/IMarshal.GetMarshalSizeMax
dev_langs:
- c++
req.header: objidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: ObjIdl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- ObjIdl.h
api_name:
- IMarshal.GetMarshalSizeMax
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IMarshal::GetMarshalSizeMax


## -description


Retrieves the maximum size of the buffer that will be needed during marshaling.


## -parameters




### -param riid [in]

A reference to the identifier of the interface to be marshaled.


### -param pv [in]

The interface pointer to be marshaled. This parameter can be <b>NULL</b>.


### -param dwDestContext [in]

The destination context where the specified interface is to be unmarshaled. Possible values come from the enumeration <a href="https://docs.microsoft.com/windows/desktop/api/wtypesbase/ne-wtypesbase-mshctx">MSHCTX</a>. Unmarshaling can occur either in another apartment of the current process (MSHCTX_INPROC) or in another process on the same computer as the current process (MSHCTX_LOCAL).


### -param pvDestContext [in]

This parameter is reserved and must be <b>NULL</b>.


### -param mshlflags [in]

Indicates whether the data to be marshaled is to be transmitted back to the client processâ€”the typical caseâ€”or written to a global table, where it can be retrieved by multiple clients. Possible values come from the <a href="https://docs.microsoft.com/windows/desktop/api/wtypesbase/ne-wtypesbase-mshlflags">MSHLFLAGS</a> enumeration.


### -param pSize [out]

A pointer to a variable that receives the maximum size of the buffer.


## -returns



This method can return the standard return values E_FAIL and S_OK, as well as the following value.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_NOINTERFACE</b></dt>
</dl>
</td>
<td width="60%">
The specified interface is not supported.

</td>
</tr>
</table>
 




## -remarks



This method is called indirectly, in a call to <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cogetmarshalsizemax">CoGetMarshalSizeMax</a>, by whatever code in the server process is responsible for marshaling a pointer to an interface on an object. This marshaling code is usually a stub generated by COM for one of several interfaces that can marshal a pointer to an interface implemented on an entirely different object. Examples include the <a href="https://docs.microsoft.com/windows/desktop/api/unknwnbase/nn-unknwnbase-iclassfactory">IClassFactory</a> and <a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nn-oleidl-ioleitemcontainer">IOleItemContainer</a> interfaces. For purposes of discussion, the code responsible for marshaling a pointer is called the <i>marshaling stub</i>.

To create a proxy for an object, COM requires two pieces of information from the original object: the amount of data to be written to the marshaling stream and the proxy's CLSID.

The marshaling stub obtains these two pieces of information with successive calls to <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cogetmarshalsizemax">CoGetMarshalSizeMax</a> and <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-comarshalinterface">CoMarshalInterface</a>.

<h3><a id="Notes_to_Callers"></a><a id="notes_to_callers"></a><a id="NOTES_TO_CALLERS"></a>Notes to Callers</h3>
The marshaling stub, through a call to <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cogetmarshalsizemax">CoGetMarshalSizeMax</a>, calls the object's implementation of this method to preallocate the stream buffer that will be passed to <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imarshal-marshalinterface">MarshalInterface</a>.

You do not explicitly call this method if you are implementing existing COM interfaces or using the Microsoft Interface Definition Language (MIDL) to define your own custom interfaces. In either case, the MIDL-generated stub automatically makes the call.

If you are not using MIDL to define your own interface (see <a href="https://docs.microsoft.com/windows/desktop/com/defining-com-interfaces">Defining COM Interfaces</a>), your marshaling stub does not have to call <b>GetMarshalSizeMax</b>, although doing so is highly recommended. An object knows better than an interface stub what the maximum size of a marshaling data packet is likely to be. Therefore, unless you are providing an automatically growing stream that is so efficient that the overhead of expanding it is insignificant, you should call this method even when implementing your own interfaces.

The value returned by this method is guaranteed to be valid only as long as the internal state of the object being marshaled does not change. Therefore, the actual marshaling should be done immediately after this function returns, or the stub runs the risk that the object, because of some change in state, might require more memory to marshal than it originally indicated.

<h3><a id="Notes_to_Implementers"></a><a id="notes_to_implementers"></a><a id="NOTES_TO_IMPLEMENTERS"></a>Notes to Implementers</h3>
Your implementation of <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imarshal-marshalinterface">MarshalInterface</a> will use the preallocated buffer to write marshaling data into the stream. If the buffer is too small, the marshaling operation will fail. Therefore, the value returned by this method must be a conservative estimate of the amount of data that will be needed to marshal the interface. Violation of this requirement should be treated as a catastrophic error.

In a subsequent call to <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imarshal-marshalinterface">MarshalInterface</a>, your <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nn-objidl-imarshal">IMarshal</a> implementation cannot rely on the caller actually having called <b>GetMarshalSizeMax</b> beforehand. It must still be wary of STG_E_MEDIUMFULL errors returned by the stream and be prepared to handle them gracefully.

To ensure that your implementation of <b>GetMarshalSizeMax</b> will continue to work properly as new destination contexts are supported in the future, delegate marshaling to the COM default implementation for all <i>dwDestContext</i> values that your implementation does not understand. To delegate marshaling to the COM default implementation, call the <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cogetstandardmarshal">CoGetStandardMarshal</a> function.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cogetmarshalsizemax">CoGetMarshalSizeMax</a>



<a href="https://docs.microsoft.com/windows/desktop/api/objidl/nn-objidl-imarshal">IMarshal</a>
 

 

