---
UID: NF:objidl.IRpcChannelBuffer.GetDestCtx
title: IRpcChannelBuffer::GetDestCtx (objidl.h)
description: Retrieves the destination context for the RPC channel.
old-location: com\irpcchannelbuffer_getdestctx.htm
tech.root: com
ms.assetid: 34599869-0c85-403a-88c2-ea8e865d533a
ms.date: 12/05/2018
ms.keywords: GetDestCtx, GetDestCtx method [COM], GetDestCtx method [COM],IRpcChannelBuffer interface, IRpcChannelBuffer interface [COM],GetDestCtx method, IRpcChannelBuffer.GetDestCtx, IRpcChannelBuffer::GetDestCtx, _com_irpcchannelbuffer_getdestctx, com.irpcchannelbuffer_getdestctx, objidlbase/IRpcChannelBuffer::GetDestCtx
f1_keywords:
- objidl/IRpcChannelBuffer.GetDestCtx
dev_langs:
- c++
req.header: objidl.h
req.include-header: ObjIdl.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: ObjIdl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- objidlbase.h
api_name:
- IRpcChannelBuffer.GetDestCtx
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IRpcChannelBuffer::GetDestCtx


## -description


Retrieves the destination context for the RPC channel.


## -parameters




### -param pdwDestContext [out]

The destination context in which the interface is unmarshaled. Possible values come from the <a href="https://docs.microsoft.com/windows/desktop/api/wtypesbase/ne-wtypesbase-mshctx">MSHCTX</a> enumeration.


### -param ppvDestContext [out]

This parameter is reserved and must be <b>NULL</b>.


## -returns



This method can return the standard return values E_INVALIDARG, E_OUTOFMEMORY, E_UNEXPECTED, E_FAIL, and S_OK.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/objidl/nn-objidl-irpcchannelbuffer">IRpcChannelBuffer</a>
 

 

