---
UID: NF:objidlbase.IMarshal.MarshalInterface
title: IMarshal::MarshalInterface (objidlbase.h)
description: Marshals an interface pointer.
old-location: com\imarshal_marshalinterface.htm
tech.root: com
ms.assetid: c48a7123-bd00-4ff3-8880-7fc4b99e4299
ms.date: 12/05/2018
ms.keywords: IMarshal interface [COM],MarshalInterface method, IMarshal.MarshalInterface, IMarshal::MarshalInterface, MarshalInterface, MarshalInterface method [COM], MarshalInterface method [COM],IMarshal interface, _com_imarshal_marshalinterface, com.imarshal_marshalinterface, objidlbase/IMarshal::MarshalInterface
f1_keywords:
- objidlbase/IMarshal.MarshalInterface
dev_langs:
- c++
req.header: objidlbase.h
req.include-header: ObjIdl.h
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps \| UWP apps]
req.target-min-winversvr: Windows 2000 Server [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: ObjIdl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- objidlbase.h
api_name:
- IMarshal.MarshalInterface
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IMarshal::MarshalInterface


## -description


Marshals an interface pointer.


## -parameters




### -param pStm [in]

A pointer to the stream to be used during marshaling.


### -param riid [in]

A reference to the identifier of the interface to be marshaled. This interface must be derived from the <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> interface.


### -param pv [in]

A pointer to the interface pointer to be marshaled. This parameter can be <b>NULL</b> if the caller does not have a pointer to the desired interface.


### -param dwDestContext [in]

The destination context where the specified interface is to be unmarshaled. Possible values for <i>dwDestContext</i> come from the enumeration <a href="https://docs.microsoft.com/windows/desktop/api/wtypesbase/ne-wtypesbase-mshctx">MSHCTX</a>. Currently, unmarshaling can occur either in another apartment of the current process (MSHCTX_INPROC) or in another process on the same computer as the current process (MSHCTX_LOCAL).


### -param pvDestContext [in]

This parameter is reserved and must be 0.


### -param mshlflags [in]

Indicates whether the data to be marshaled is to be transmitted back to the client process—the typical case—or written to a global table, where it can be retrieved by multiple clients. Possible values come from the <a href="https://docs.microsoft.com/windows/desktop/api/wtypesbase/ne-wtypesbase-mshlflags">MSHLFLAGS</a> enumeration.


## -returns



This method can return the standard return value E_FAIL, as well as the following values.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
The interface pointer was marshaled successfully.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_NOINTERFACE</b></dt>
</dl>
</td>
<td width="60%">
The specified interface is not supported.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>STG_E_MEDIUMFULL</b></dt>
</dl>
</td>
<td width="60%">
The stream is full.

</td>
</tr>
</table>
 




## -remarks



This method is called indirectly, in  a call to <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-comarshalinterface">CoMarshalInterface</a>, by whatever code in the server process is responsible for marshaling a pointer to an interface on an object. This marshaling code is usually a stub generated by COM for one of several interfaces that can marshal a pointer to an interface implemented on an entirely different object. Examples include the <a href="https://docs.microsoft.com/windows/desktop/api/unknwnbase/nn-unknwnbase-iclassfactory">IClassFactory</a> and <a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nn-oleidl-ioleitemcontainer">IOleItemContainer</a> interfaces. For purposes of discussion, the code responsible for marshaling a pointer is called the <i>marshaling stub</i>.

<h3><a id="Notes_to_Callers"></a><a id="notes_to_callers"></a><a id="NOTES_TO_CALLERS"></a>Notes to Callers</h3>
Typically, rather than calling <b>MarshalInterface</b> directly, your marshaling stub instead should call the <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-comarshalinterface">CoMarshalInterface</a> function, which contains a call to this method. The stub makes this call to command an object to write its marshaling data into a stream. The stub then either passes the marshaling data back to the client process or writes it to a global table, where it can be unmarshaled by multiple clients. The stub's call to <b>CoMarshalInterface</b> is normally preceded by a call to <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cogetmarshalsizemax">CoGetMarshalSizeMax</a> to get the maximum size of the stream buffer into which the marshaling data will be written.



You do not explicitly call this method if you are implementing existing COM interfaces or defining your own interfaces using the Microsoft Interface Definition Language (MIDL). In either case, the MIDL-generated stub automatically makes the call.



If you are not using MIDL to define your own interface, your marshaling stub must call this method, either directly or indirectly. Your stub implementation should call <b>MarshalInterface</b> immediately after its previous call to <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imarshal-getmarshalsizemax">IMarshal::GetMarshalSizeMax</a> returns. Because the value returned by <b>GetMarshalSizeMax</b> is guaranteed to be valid only as long as the internal state of the object being marshaled does not change, a delay in calling <b>MarshalInterface</b> runs the risk that the object will require a larger stream buffer than originally indicated.

If the caller has a pointer to the interface to be marshaled, it should, as a matter of efficiency, use the <i>pv</i> parameter to pass that pointer. In this way, an implementation that may use such a pointer to determine the appropriate CLSID for the proxy does not have to call <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nf-unknwn-iunknown-queryinterface(q)">QueryInterface</a> on itself. If a caller does not have a pointer to the interface to be marshaled, it can pass <b>NULL</b>.

<h3><a id="Notes_to_Implementers"></a><a id="notes_to_implementers"></a><a id="NOTES_TO_IMPLEMENTERS"></a>Notes to Implementers</h3>
Your implementation of <b>MarshalInterface</b> must write to the stream whatever data is needed to initialize the proxy on the receiving side. Such data would include a reference to the interface to be marshaled, a <a href="https://docs.microsoft.com/windows/desktop/api/wtypesbase/ne-wtypesbase-mshlflags">MSHLFLAGS</a> value specifying whether the data should be returned to the client process or written to a global table, and whatever is needed to connect to the object, such as a named pipe, handle to a window, or pointer to an RPC channel.

Your implementation should not assume that the stream is large enough to hold all the data. Rather, it should gracefully handle a STG_E_MEDIUMFULL error. Just before exiting, your implementation should position the seek pointer in the stream immediately after the last byte of data written.



If the pv parameter is <b>NULL</b> and your implementation needs an interface pointer, it can call <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nf-unknwn-iunknown-queryinterface(q)">QueryInterface</a> on the current object to get it. The <i>pv</i> parameter exists merely to improve efficiency.



To ensure that your implementation of <b>MarshalInterface</b> continues to work properly as new destination contexts are supported in the future, delegate marshaling to the COM default implementation for all <i>dwDestContext</i> values that your implementation does not handle. To delegate marshaling to the COM default implementation, call the <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cogetstandardmarshal">CoGetStandardMarshal</a> helper function.

Using the <a href="https://docs.microsoft.com/windows/desktop/api/wtypesbase/ne-wtypesbase-mshlflags">MSHLFLAGS</a> enumeration, callers can specify whether an interface pointer is to be marshaled back to a single client or written to a global table, where it can be unmarshaled by multiple clients. You must make sure that your object can handle calls from the multiple proxies that might be created from the same initialization data.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-comarshalinterface">CoMarshalInterface</a>



<a href="https://docs.microsoft.com/windows/desktop/api/objidl/nn-objidl-imarshal">IMarshal</a>
 

 

