---
UID: NF:ocidl.IOleInPlaceSiteWindowless.ScrollRect
title: IOleInPlaceSiteWindowless::ScrollRect (ocidl.h)
description: Enables an object to scroll an area within its in-place active image on the screen.
old-location: com\ioleinplacesitewindowless_scrollrect.htm
tech.root: com
ms.assetid: 1eeb1aee-8cd4-4d27-8b6f-f76305bbe69f
ms.date: 12/05/2018
ms.keywords: IOleInPlaceSiteWindowless interface [COM],ScrollRect method, IOleInPlaceSiteWindowless.ScrollRect, IOleInPlaceSiteWindowless::ScrollRect, ScrollRect, ScrollRect method [COM], ScrollRect method [COM],IOleInPlaceSiteWindowless interface, _ole_ioleinplacesitewindowless_scrollrect, com.ioleinplacesitewindowless_scrollrect, ocidl/IOleInPlaceSiteWindowless::ScrollRect
f1_keywords:
- ocidl/IOleInPlaceSiteWindowless.ScrollRect
dev_langs:
- c++
req.header: ocidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: OCIdl.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- OCIdl.h
api_name:
- IOleInPlaceSiteWindowless.ScrollRect
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOleInPlaceSiteWindowless::ScrollRect


## -description


Enables an object to scroll an area within its in-place active image on the screen.


## -parameters




### -param dx [in]

The amount to scroll the x-axis.


### -param dy [in]

The amount to scroll the y-axis.


### -param pRectScroll [in]

The rectangle to scroll, in client coordinates of the containing window. A value of <b>NULL</b> indicates the full object.


### -param pRectClip [in]

The rectangle to clip. Only pixels scrolling into this rectangle are drawn. Pixels scrolling out are not. If this parameter is <b>NULL</b>, the rectangle is not clipped.


## -returns



This method returns S_OK on success.




## -remarks



This method should take in account the fact that the caller may be transparent and that there may be opaque or transparent overlapping objects. See Notes to Implementers below for suggestions on algorithms this method can use.

<h3><a id="Notes_to_Implementers"></a><a id="notes_to_implementers"></a><a id="NOTES_TO_IMPLEMENTERS"></a>Notes to Implementers</h3>
Containers can implement this method in a variety of ways. However, all of them should account for the possibility that the object requesting scrolling may be transparent or may not have a solid background. Containers should also take into account that there may be overlapping objects.

The simplest way to implement this method consists in simply redrawing the rectangle to scroll.

An added refinement to this simple implementation is to use the <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-scrolldc">ScrollDC</a> function when the object requesting the scroll is opaque, the object has a solid background, and there are no overlapping objects.

More sophisticated implementations can use the following procedure:

<ul>
<li>Check whether the object is opaque and has a solid background, using <a href="https://docs.microsoft.com/windows/desktop/api/ocidl/nf-ocidl-iviewobjectex-getviewstatus">IViewObjectEx::GetViewStatus</a>. If not, simply invalidate the rectangle to scroll. An added refinement is to check whether the scrolling rectangle is entirely in the opaque region of a partially transparent object.</li>
<li>Get the window device context.</li>
<li>Clip out the opaque parts of any overlapping object returned by <a href="https://docs.microsoft.com/windows/desktop/api/ocidl/nf-ocidl-iviewobjectex-getrect">IViewObjectEx::GetRect</a>.</li>
<li>Finally, call the <a href="https://docs.microsoft.com/windows/desktop/api/winuser/nf-winuser-scrolldc">ScrollDC</a> function.</li>
<li>Redraw the previously invalidated transparent parts of any overlapping object.</li>
</ul>
Regardless of the scrolling and clipping rectangle, only pixels contained in the object's site rectangle will be painted. The area uncovered by the scrolling operation is invalidated and redrawn immediately, before this method returns.

All redraw generated by this method should happen synchronously before this method returns.

This method should automatically hide the caret during the scrolling operation and should move the caret by the scrolling amounts if it is inside the clip rectangle.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/ocidl/nn-ocidl-ioleinplacesitewindowless">IOleInPlaceSiteWindowless</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ocidl/nf-ocidl-iviewobjectex-getrect">IViewObjectEx::GetRect</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ocidl/nf-ocidl-iviewobjectex-getviewstatus">IViewObjectEx::GetViewStatus</a>
 

 

