---
UID: NF:oleacc.IAccessible.get_accChildCount
title: IAccessible::get_accChildCount (oleacc.h)
description: The IAccessible::get_accChildCount method retrieves the number of children that belong to this object. All objects must support this property.
old-location: winauto\iaccessible_iaccessible__get_accchildcount.htm
tech.root: WinAuto
ms.assetid: d80d59c0-7694-4cc6-9887-2fec7186f32e
ms.date: 12/05/2018
ms.keywords: IAccessible interface [Windows Accessibility],get_accChildCount method, IAccessible.get_accChildCount, IAccessible::get_accChildCount, _msaa_IAccessible_get_accChildCount, get_accChildCount, get_accChildCount method [Windows Accessibility], get_accChildCount method [Windows Accessibility],IAccessible interface, msaa.iaccessible_iaccessible__get_accchildcount, oleacc/IAccessible::get_accChildCount, winauto.iaccessible_iaccessible__get_accchildcount
f1_keywords:
- oleacc/IAccessible.get_accChildCount
dev_langs:
- c++
req.header: oleacc.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Oleacc.lib
req.dll: Oleacc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Oleacc.dll
api_name:
- IAccessible.get_accChildCount
targetos: Windows
req.typenames: 
req.redist: Active Accessibility 1.3 RDK on Windows NT 4.0 with SP6 and later and Windows 95
ms.custom: 19H1
---

# IAccessible::get_accChildCount


## -description


The <b>IAccessible::get_accChildCount</b> method retrieves the number of children that belong to this object. All objects must support this property.


## -parameters




### -param pcountChildren [out, retval]

Type: <b>long*</b>

 Address of a variable that receives the number of children that belong to this object. The children are accessible objects or child elements. If the object has no children, this value is zero.


## -returns



Type: <b><a href="https://docs.microsoft.com/windows/desktop/WinProg/windows-data-types">HRESULT</a></b>

If successful, returns S_OK.

If not successful, returns a standard <a href="https://docs.microsoft.com/windows/desktop/WinAuto/return-values">COM error code</a>. Servers return these values, but clients must always check output parameters to ensure that they contain valid values. For more information, see <a href="https://docs.microsoft.com/windows/desktop/WinAuto/checking-iaccessible-return-values">Checking IAccessible Return Values</a>.




## -remarks



The number of children in an object can change. An application tracks the changes to the child count by watching for <a href="https://docs.microsoft.com/windows/desktop/WinAuto/event-constants">EVENT_OBJECT_CREATE</a> and <a href="https://docs.microsoft.com/windows/desktop/WinAuto/event-constants">EVENT_OBJECT_DESTROY</a> events generated by this object.

<b>Note to server developers:  </b>If the object does not have any children, return S_OK and set <i>pcountChildren</i> to zero.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/oleacc/nf-oleacc-accessiblechildren">AccessibleChildren</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oleacc/nn-oleacc-iaccessible">IAccessible</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oleacc/nf-oleacc-iaccessible-get_accchild">IAccessible::get_accChild</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oleacc/nf-oleacc-iaccessible-get_accparent">IAccessible::get_accParent</a>
 

 

