---
UID: NF:oleidl.IOleInPlaceActiveObject.EnableModeless
title: IOleInPlaceActiveObject::EnableModeless (oleidl.h)
description: Enables or disables modeless dialog boxes when the container creates or destroys a modal dialog box.
old-location: com\ioleinplaceactiveobject_enablemodeless.htm
tech.root: com
ms.assetid: 2fc45490-b3fe-48fd-a41c-2b7f35b09edc
ms.date: 12/05/2018
ms.keywords: EnableModeless, EnableModeless method [COM], EnableModeless method [COM],IOleInPlaceActiveObject interface, IOleInPlaceActiveObject interface [COM],EnableModeless method, IOleInPlaceActiveObject.EnableModeless, IOleInPlaceActiveObject::EnableModeless, _ole_ioleinplaceactiveobject_enablemodeless, com.ioleinplaceactiveobject_enablemodeless, oleidl/IOleInPlaceActiveObject::EnableModeless
f1_keywords:
- oleidl/IOleInPlaceActiveObject.EnableModeless
dev_langs:
- c++
req.header: oleidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: OleIdl.Idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- OleIdl.h
api_name:
- IOleInPlaceActiveObject.EnableModeless
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOleInPlaceActiveObject::EnableModeless


## -description


Enables or disables modeless dialog boxes when the container creates or destroys a modal dialog box.


## -parameters




### -param fEnable [in]

Indicates whether to enable modeless dialog box windows (<b>TRUE</b>) or disable them <b>FALSE</b>.


## -returns



This method returns S_OK on success.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nn-oleidl-ioleinplaceactiveobject">IOleInPlaceActiveObject</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-ioleinplaceactiveobject-enablemodeless">IOleInPlaceActiveObject::EnableModeless</a>
 

 

