---
UID: NF:oleidl.IOleLink.BindIfRunning
title: IOleLink::BindIfRunning (oleidl.h)
description: Activates the connection between the linked object and the link source if the link source is already running.
old-location: com\iolelink_bindifrunning.htm
tech.root: com
ms.assetid: 791fbb3c-6b73-490c-a69b-ba58fd386de4
ms.date: 12/05/2018
ms.keywords: BindIfRunning, BindIfRunning method [COM], BindIfRunning method [COM],IOleLink interface, IOleLink interface [COM],BindIfRunning method, IOleLink.BindIfRunning, IOleLink::BindIfRunning, _ole_iolelink_bindifrunning, com.iolelink_bindifrunning, oleidl/IOleLink::BindIfRunning
f1_keywords:
- oleidl/IOleLink.BindIfRunning
dev_langs:
- c++
req.header: oleidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: OleIdl.Idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- OleIdl.h
api_name:
- IOleLink.BindIfRunning
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOleLink::BindIfRunning


## -description


Activates the connection between the linked object and the link source if the link source is already running.


## -parameters






## -returns



This method returns S_OK on success. Other possible return values include the following.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_FALSE</b></dt>
</dl>
</td>
<td width="60%">
The link source is not running.

</td>
</tr>
</table>
 

Binding the moniker might require calling <a href="https://docs.microsoft.com/windows/desktop/api/objbase/nf-objbase-createbindctx">CreateBindCtx</a>, <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imoniker-isrunning">IMoniker::IsRunning</a>, or <a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-iolelink-bindtosource">IOleLink::BindToSource</a>; therefore, errors generated by these functions can also be returned.




## -remarks



You typically do not need to call <b>IOleLink::BindIfRunning</b>. This method is primarily called by the linked object.

<h3><a id="Notes_to_Implementers"></a><a id="notes_to_implementers"></a><a id="NOTES_TO_IMPLEMENTERS"></a>Notes to Implementers</h3>
The linked object's implementation of <b>IOleLink::BindIfRunning</b> checks the running object table (ROT) to determine whether the link source is already running. It checks both the relative and absolute monikers. If the link source is running, <b>IOleLink::BindIfRunning</b> calls <a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-iolelink-bindtosource">IOleLink::BindToSource</a> to connect the linked object to the link source.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nn-oleidl-iolelink">IOleLink</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-iolelink-bindtosource">IOleLink::BindToSource</a>
 

 

