---
UID: NF:oleidl.IOleLink.GetSourceDisplayName
title: IOleLink::GetSourceDisplayName (oleidl.h)
description: Retrieves the display name of the link source of the linked object.
old-location: com\iolelink_getsourcedisplayname.htm
tech.root: com
ms.assetid: a4c5bc82-f423-4a02-b8d4-49b38a9c0f42
ms.date: 12/05/2018
ms.keywords: GetSourceDisplayName, GetSourceDisplayName method [COM], GetSourceDisplayName method [COM],IOleLink interface, IOleLink interface [COM],GetSourceDisplayName method, IOleLink.GetSourceDisplayName, IOleLink::GetSourceDisplayName, _ole_iolelink_getsourcedisplayname, com.iolelink_getsourcedisplayname, oleidl/IOleLink::GetSourceDisplayName
f1_keywords:
- oleidl/IOleLink.GetSourceDisplayName
dev_langs:
- c++
req.header: oleidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: OleIdl.Idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- OleIdl.h
api_name:
- IOleLink.GetSourceDisplayName
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOleLink::GetSourceDisplayName


## -description


Retrieves the display name of the link source of the linked object.


## -parameters




### -param ppszDisplayName [out]

Address of a pointer variable that receives a pointer to the display name of the link source. If an error occurs, <i>ppszDisplayName</i> is set to <b>NULL</b>; otherwise, the implementation must use <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imalloc-alloc">IMalloc::Alloc</a> to allocate the string returned in <i>ppszDisplayName</i>, and the caller is responsible for calling <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imalloc-free">IMalloc::Free</a> to free it. Both caller and called use the allocator returned by <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cogetmalloc">CoGetMalloc</a>.


## -returns



This method returns S_OK on success. Other possible return values include the following.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_FAIL</b></dt>
</dl>
</td>
<td width="60%">
The operation failed.

</td>
</tr>
</table>
 

Retrieving the display name requires calling these functions; therefore, this method may return errors generated by <a href="https://docs.microsoft.com/windows/desktop/api/objbase/nf-objbase-createbindctx">CreateBindCtx</a> and <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imoniker-getdisplayname">IMoniker::GetDisplayName</a>.





## -remarks



<h3><a id="Notes_to_Callers"></a><a id="notes_to_callers"></a><a id="NOTES_TO_CALLERS"></a>Notes to Callers</h3>
Your container application can call <b>IOleLink::GetSourceDisplayName</b> to display the current source of a link.

The current source of a link is displayed in the <b>Links</b> dialog box. If you use the <a href="https://docs.microsoft.com/windows/desktop/api/oledlg/nf-oledlg-oleuieditlinksa">OleUIEditLinks</a> function to display the <b>Links</b> dialog box, you must implement the <a href="https://docs.microsoft.com/windows/desktop/api/oledlg/nn-oledlg-ioleuilinkcontainera">IOleUILinkContainer</a> interface. The dialog box calls your implementations of <a href="https://docs.microsoft.com/windows/desktop/api/oledlg/nf-oledlg-ioleuilinkcontainera-getlinksource">IOleUILinkContainer::GetLinkSource</a> to get the string it should display. Your implementation of that method can call <b>IOleLink::GetSourceDisplayName</b>.

<h3><a id="Notes_to_Implementers"></a><a id="notes_to_implementers"></a><a id="NOTES_TO_IMPLEMENTERS"></a>Notes to Implementers</h3>
The linked object's implementation of <b>IOleLink::GetSourceDisplayName</b> calls <a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-iolelink-getsourcemoniker">IOleLink::GetSourceMoniker</a> to get the link source moniker, and then calls <a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imoniker-getdisplayname">IMoniker::GetDisplayName</a> to get that moniker's display name. This operation is potentially expensive because it might require binding the moniker. All of the system-provided monikers can return a display name without binding, but there is no guarantee that other moniker implementations can. Instead of making repeated calls to <b>IOleLink::GetSourceDisplayName</b>, your container application can cache the name and update it whenever the link source is bound.





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/objidl/nf-objidl-imoniker-getdisplayname">IMoniker::GetDisplayName</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nn-oleidl-iolelink">IOleLink</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-iolelink-setsourcedisplayname">IOleLink::SetSourceDisplayName</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oledlg/nn-oledlg-ioleuilinkcontainera">IOleUILinkContainer</a>



<a href="https://docs.microsoft.com/windows/desktop/api/oledlg/nf-oledlg-oleuieditlinksa">OleUIEditLinks</a>
 

 

