---
UID: NS:oleidl.tagOleMenuGroupWidths
title: OLEMENUGROUPWIDTHS (oleidl.h)
description: Indicates the number of menu items in each of the six menu groups of a menu shared between a container and an object server during an in-place editing session. This is the mechanism for building a shared menu.
old-location: com\olemenugroupwidths.htm
tech.root: com
ms.assetid: e6ad4ab7-0e53-4fad-8f2e-a0ff7b376815
ms.date: 12/05/2018
ms.keywords: '*LPOLEMENUGROUPWIDTHS, LPOLEMENUGROUPWIDTHS, LPOLEMENUGROUPWIDTHS structure pointer [COM], OLEMENUGROUPWIDTHS, OLEMENUGROUPWIDTHS structure [COM], _ole_OLEMENUGROUPWIDTHS, com.olemenugroupwidths, oleidl/LPOLEMENUGROUPWIDTHS, oleidl/OLEMENUGROUPWIDTHS'
f1_keywords:
- oleidl/OLEMENUGROUPWIDTHS
dev_langs:
- c++
req.header: oleidl.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- OleIdl.h
api_name:
- OLEMENUGROUPWIDTHS
targetos: Windows
req.typenames: OLEMENUGROUPWIDTHS, *LPOLEMENUGROUPWIDTHS
req.redist: 
ms.custom: 19H1
---

# OLEMENUGROUPWIDTHS structure


## -description


Indicates the number of menu items in each of the six menu groups of a menu shared between a container and an object server during an in-place editing session. This is the mechanism for building a shared menu.


## -struct-fields




### -field width

An array whose elements contain the number of menu items in each of the six menu groups of a shared in-place editing menu. Each menu group can have any number of menu items. The container uses elements 0, 2, and 4 to indicate the number of menu items in its <b>File</b>, <b>View</b>, and <b>Window</b> menu groups. The object server uses elements 1, 3, and 5 to indicate the number of menu items in its <b>Edit</b>, <b>Object</b>, and <b>Help</b> menu groups.



## -remarks



A container application and an object server use this structure to build a shared menu. The object server initializes to zeros the array elements in an <b>OLEMENUGROUPWIDTHS</b> structure and passes a pointer to it along with a menu handle to the container in a call to <a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-ioleinplaceframe-insertmenus">IOleInPlaceFrame::InsertMenus</a>. The container adds its menu items to the menu, and fills in the structure with the number of items in each of its groups (indexes 0, 2, and 4). The server then uses the group width values returned by the container to insert its menu items in the appropriate position in the menu. The server fills in the structure with the number of items in each of its groups (indexes 1, 3, and 5), and then passes the structure to OLE in a call to the <a href="https://docs.microsoft.com/windows/desktop/api/ole2/nf-ole2-olecreatemenudescriptor">OleCreateMenuDescriptor</a> function. This enables OLE to intercept the container's menu messages and redirect the messages generated by the server's menus.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/oleidl/nf-oleidl-ioleinplaceframe-insertmenus">IOleInPlaceFrame::InsertMenus</a>



<a href="https://docs.microsoft.com/windows/desktop/api/ole2/nf-ole2-olecreatemenudescriptor">OleCreateMenuDescriptor</a>
 

 

