---
UID: NE:opmapi._OPM_IMAGE_ASPECT_RATIO_EN300294
title: OPM_IMAGE_ASPECT_RATIO_EN300294 (opmapi.h)
description: Specifies the aspect ratio for ETSI EN 300 294.
old-location: mf\opm_image_aspect_ratio_en300294.htm
tech.root: medfound
ms.assetid: 3c0fc524-b75f-4397-bd01-25be44062e8c
ms.date: 12/05/2018
ms.keywords: OPM_ASPECT_RATIO_EN300294_BOX_14_BY_9_CENTER, OPM_ASPECT_RATIO_EN300294_BOX_14_BY_9_TOP, OPM_ASPECT_RATIO_EN300294_BOX_16_BY_9_CENTER, OPM_ASPECT_RATIO_EN300294_BOX_16_BY_9_TOP, OPM_ASPECT_RATIO_EN300294_BOX_GT_16_BY_9_CENTER, OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_16_BY_9_ANAMORPHIC, OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_4_BY_3, OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_4_BY_3_PROTECTED_CENTER, OPM_ASPECT_RATIO_FORCE_ULONG, OPM_IMAGE_ASPECT_RATIO_EN300294, OPM_IMAGE_ASPECT_RATIO_EN300294 enumeration [Media Foundation], mf.opm_image_aspect_ratio_en300294, opmapi/OPM_ASPECT_RATIO_EN300294_BOX_14_BY_9_CENTER, opmapi/OPM_ASPECT_RATIO_EN300294_BOX_14_BY_9_TOP, opmapi/OPM_ASPECT_RATIO_EN300294_BOX_16_BY_9_CENTER, opmapi/OPM_ASPECT_RATIO_EN300294_BOX_16_BY_9_TOP, opmapi/OPM_ASPECT_RATIO_EN300294_BOX_GT_16_BY_9_CENTER, opmapi/OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_16_BY_9_ANAMORPHIC, opmapi/OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_4_BY_3, opmapi/OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_4_BY_3_PROTECTED_CENTER, opmapi/OPM_ASPECT_RATIO_FORCE_ULONG, opmapi/OPM_IMAGE_ASPECT_RATIO_EN300294
f1_keywords:
- opmapi/OPM_IMAGE_ASPECT_RATIO_EN300294
dev_langs:
- c++
req.header: opmapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Opmapi.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- opmapi.h
api_name:
- OPM_IMAGE_ASPECT_RATIO_EN300294
targetos: Windows
req.typenames: OPM_IMAGE_ASPECT_RATIO_EN300294
req.redist: 
ms.custom: 19H1
---

# OPM_IMAGE_ASPECT_RATIO_EN300294 enumeration


## -description


Specifies the aspect ratio for ETSI EN 300 294.


## -enum-fields




### -field OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_4_BY_3

Full format 4:3.


### -field OPM_ASPECT_RATIO_EN300294_BOX_14_BY_9_CENTER

Box 14:9 center.


### -field OPM_ASPECT_RATIO_EN300294_BOX_14_BY_9_TOP

Box 14:9 top.


### -field OPM_ASPECT_RATIO_EN300294_BOX_16_BY_9_CENTER

Box 16:9 center.


### -field OPM_ASPECT_RATIO_EN300294_BOX_16_BY_9_TOP

Box 16:9 top.


### -field OPM_ASPECT_RATIO_EN300294_BOX_GT_16_BY_9_CENTER

Box &gt; 16:9 center.


### -field OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_4_BY_3_PROTECTED_CENTER

Full format 4:3 (shoot and protect 14:9 center).
          


### -field OPM_ASPECT_RATIO_EN300294_FULL_FORMAT_16_BY_9_ANAMORPHIC

Full format 16:9 (anamorphic).


### -field OPM_ASPECT_RATIO_FORCE_ULONG

Reserved.


## -remarks



This enumeration is numerically equivalent to the <b>COPP_ImageAspectRatio_EN300294</b> enumeration used in Certified Output Protection Protocol (COPP).




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/opm-enumerations">OPM Enumerations</a>



<a href="https://docs.microsoft.com/windows/win32/api/opmapi/ns-opmapi-opm_set_acp_and_cgmsa_signaling_parameters">OPM_SET_ACP_AND_CGMSA_SIGNALING_PARAMETERS</a>
 

 

