---
UID: NF:opmapi.IOPMVideoOutput.StartInitialization
title: IOPMVideoOutput::StartInitialization (opmapi.h)
description: Begins the initialization sequence for an Output Protection Manager (OPM) session.
old-location: mf\iopmvideooutput_iopmvideooutput__startinitialization.htm
tech.root: medfound
ms.assetid: eeedeb4b-753f-4efb-b8ef-732cce116b42
ms.date: 12/05/2018
ms.keywords: IOPMVideoOutput interface [Media Foundation],StartInitialization method, IOPMVideoOutput.StartInitialization, IOPMVideoOutput::StartInitialization, StartInitialization, StartInitialization method [Media Foundation], StartInitialization method [Media Foundation],IOPMVideoOutput interface, mf.iopmvideooutput_iopmvideooutput__startinitialization, opmapi/IOPMVideoOutput::StartInitialization
f1_keywords:
- opmapi/IOPMVideoOutput.StartInitialization
dev_langs:
- c++
req.header: opmapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- opmapi.h
api_name:
- IOPMVideoOutput.StartInitialization
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IOPMVideoOutput::StartInitialization


## -description


Begins the initialization sequence for an Output Protection Manager (OPM) session.


## -parameters




### -param prnRandomNumber [out]

Pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/ksopmapi/ns-ksopmapi-opm_random_number">OPM_RANDOM_NUMBER</a> structure. The structure receives a 128-bit random number generated by the display driver. This number is required for the <a href="https://docs.microsoft.com/windows/desktop/api/opmapi/nf-opmapi-iopmvideooutput-finishinitialization">IOPMVideoOutput::FinishInitialization</a> method.


### -param ppbCertificate [out]

Receives a pointer to a buffer containing the display driver's certificate. The method allocates the memory for the buffer. The caller must release the memory by calling <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cotaskmemfree">CoTaskMemFree</a>.


### -param pulCertificateLength [out]

Receives the length of the buffer pointed to by  <i>ppbCertificate</i>.


## -returns



If this method succeeds, it returns <b xmlns:loc="http://microsoft.com/wdcml/l10n">S_OK</b>. Otherwise, it returns an <b xmlns:loc="http://microsoft.com/wdcml/l10n">HRESULT</b> error code.




## -remarks



This method is equivalent to the <b>IAMCertifiedOutputProtection::KeyExchange</b> method in Certified Output Protection Protocol (COPP).

The method returns a certificate chain that contains the driver's 2048-bit RSA public key. The caller must validate the certificate chain and then call <a href="https://docs.microsoft.com/windows/desktop/api/opmapi/nf-opmapi-iopmvideooutput-finishinitialization">IOPMVideoOutput::FinishInitialization</a> to establish the OPM session.

This method supports both OPM semantics and COPP semantics. COPP semantics are supported for backward compatibility; new applications should use OPM semantics.

<h3><a id="OPM_Semantics"></a><a id="opm_semantics"></a><a id="OPM_SEMANTICS"></a>OPM Semantics</h3>
The method returns an X.509 certificate chain. The certificate chain is encoded with ASN.1 Distinguished Encoding Rules (DER).

<h3><a id="COPP_Semantics"></a><a id="copp_semantics"></a><a id="COPP_SEMANTICS"></a>COPP Semantics</h3>
The method returns a COPP certificate chain. The certificate chain is returned as a UTF-8 string. You can treat the buffer returned in <i>ppbCertificate</i> as an array of <b>char</b>s.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/opmapi/nn-opmapi-iopmvideooutput">IOPMVideoOutput</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/output-protection-manager">Output Protection Manager</a>
 

 

