---
UID: NE:p2p.peer_watch_permission_tag
title: PEER_WATCH_PERMISSION (p2p.h)
description: Defines whether a peer contact can receive presence updates from a contact.
old-location: p2p\peer_watch_permission.htm
tech.root: P2PSdk
ms.assetid: e3f4a1e6-6ac8-48f8-8480-0cf60c9b4ce9
ms.date: 12/05/2018
ms.keywords: PEER_WATCH_ALLOWED, PEER_WATCH_BLOCKED, PEER_WATCH_PERMISSION, PEER_WATCH_PERMISSION enumeration [Peer Networking], p2p.peer_watch_permission, p2p/PEER_WATCH_ALLOWED, p2p/PEER_WATCH_BLOCKED, p2p/PEER_WATCH_PERMISSION
f1_keywords:
- p2p/PEER_WATCH_PERMISSION
dev_langs:
- c++
req.header: p2p.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- P2P.h
api_name:
- PEER_WATCH_PERMISSION
targetos: Windows
req.typenames: PEER_WATCH_PERMISSION
req.redist: 
ms.custom: 19H1
---

# PEER_WATCH_PERMISSION enumeration


## -description


The <b>PEER_WATCH_PERMISSION</b> enumeration defines whether a peer contact can receive presence updates from a contact.


## -enum-fields




### -field PEER_WATCH_BLOCKED

The peer contact cannot receive presence updates.


### -field PEER_WATCH_ALLOWED

The peer contact can receive presence updates.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/P2PSdk/collaboration-api-enumerations">Collaboration API Enumerations</a>
 

 

