---
UID: NF:p2p.PeerEndEnumeration
title: PeerEndEnumeration function (p2p.h)
description: The PeerEndEnumeration function releases an enumeration, for example, a record or member enumeration, and deallocates all resources associated with the enumeration.
old-location: p2p\peerendenumeration.htm
tech.root: P2PSdk
ms.assetid: cc9484fb-57b9-4970-91b8-c74db6bf2248
ms.date: 12/05/2018
ms.keywords: PeerEndEnumeration, PeerEndEnumeration function [Peer Networking], p2p.peerendenumeration, p2p/PeerEndEnumeration
f1_keywords:
- p2p/PeerEndEnumeration
dev_langs:
- c++
req.header: p2p.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP with SP2 [desktop apps only],Windows XP with SP1 with the Advanced Networking Pack forWindows XP
req.target-min-winversvr: None supported
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: P2P.lib
req.dll: P2P.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- P2P.dll
api_name:
- PeerEndEnumeration
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# PeerEndEnumeration function


## -description


The <b>PeerEndEnumeration</b> function releases an enumeration, for example, a record or member enumeration, and deallocates all resources associated with the enumeration.


## -parameters




### -param hPeerEnum [in]

Handle to the enumeration to be released. This handle is generated by a peer enumeration function.


## -returns



Returns <b>S_OK</b> if the operation succeeds. Otherwise, the function returns the following value.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
The parameter is not valid.

</td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peerenumgroups">PeerEnumGroups</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peerenumidentities">PeerEnumIdentities</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergetitemcount">PeerGetItemCount</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergetnextitem">PeerGetNextItem</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergroupenumconnections">PeerGroupEnumConnections</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergroupenummembers">PeerGroupEnumMembers</a>



<a href="https://docs.microsoft.com/windows/desktop/api/p2p/nf-p2p-peergroupenumrecords">PeerGroupEnumRecords</a>
 

 

